/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IProgressConstants;
import org.simantics.DatabaseJob;

/**
 * @author Tuukka Lehtonen
 */
public class ImageLoaderJob extends DatabaseJob {

	private GraphExplorerImplBase ge;
	private AtomicBoolean isScheduled = new AtomicBoolean();

	public ImageLoaderJob(GraphExplorerImplBase ge) {
		super("Image Loader");
		this.ge = ge;
		setSystem(true);
		setUser(false);
		setPriority(Job.DECORATE);
		setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
	}

	/**
	 * Schedules the job with {@link Job#schedule()} if necessary, i.e. if
	 * not already scheduled. This method avoids some unnecessary overhead
	 * caused by repeatedly invoking {@link Job#schedule()}.
	 * 
	 * @return <code>true</code> if scheduled, <code>false</code> otherwise
	 */
	public boolean scheduleIfNecessary(long delay) {
		if (isScheduled.compareAndSet(false, true)) {
			schedule(delay);
			return true;
		}
		return false;
	}

	@Override
	public boolean shouldRun() {
		return ge != null;
	}

	@Override
	public boolean shouldSchedule() {
		return ge != null;
	}

	@Override
	protected IStatus run(IProgressMonitor monitor) {
		try {
			isScheduled.set(false);
			GraphExplorerImplBase ge = this.ge;
			return (ge != null) ? ge.setPendingImages(monitor) : Status.CANCEL_STATUS;
		} finally {
			monitor.done();
		}
	}

	public void dispose() {
		ge = null;
	}
}