/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;

/**
 * An interface for defining an initializer for an SWT context menu with a JFace
 * selection provider.
 * 
 * @author Tuukka Lehtonen
 * @see ContextMenuInitializer
 */
public interface IContextMenuInitializer {

    /**
     * @param control the explorer component to add a context menu into
     * @param selectionProvider a provider for the selection of the specified control
     * @param site the workbench site to register the context menu for, may be
     *        <code>null</code>
     * @return the created context menu manager
     */
    IMenuManager createContextMenu(
            Control control,
            ISelectionProvider selectionProvider,
            IWorkbenchSite site);

}