/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.function.Consumer;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.utils.datastructures.UnaryFunction;

public class Dialogs {

	public static <T> void invoke(final UnaryFunction<SimanticsDialog, Shell> function, final Consumer<T> callback) {
		
		Display.getDefault().asyncExec(new Runnable() {

			@SuppressWarnings("unchecked")
			@Override
			public void run() {
				
				SimanticsDialog dialog = function.call(Display.getCurrent().getActiveShell()); 
				
				dialog.open();
				if(Window.CANCEL == dialog.getReturnCode()) callback.accept(null);
				else callback.accept((T)dialog.getSelection());
				
			}
			
		});
		
	}
	
	public static String file(Shell shell, int style, String extension) {

        FileDialog dialog = new FileDialog(shell, style);
        dialog.setFilterExtensions(new String[] { extension });
        String newFileName = dialog.open();
        return newFileName;

	}

	public static String directory(Shell shell, int style, String filterPath) {

        DirectoryDialog dialog = new DirectoryDialog(shell, style);
        if(filterPath != null) dialog.setFilterPath(filterPath);
        String newFileName = dialog.open();
        return newFileName;

	}

	public static String file(int style, String extension) {
		return file(Display.getDefault().getActiveShell(), style, extension);
	}

	public static String file(Shell shell, String extension) {
		return file(shell, SWT.OPEN, extension);
	}

	public static String file(ExecutionEvent event, String extension) {
		return file(HandlerUtil.getActiveShell(event), extension);
	}

	public static String file(ExecutionEvent event, int style, String extension) {
		return file(HandlerUtil.getActiveShell(event), style, extension);
	}

	public static String directory(int style, String filterPath) {
		return directory(Display.getDefault().getActiveShell(), style, filterPath);
	}

}
