/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.LabelDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;

public class DefaultLabelDecoratorsProcessor extends AbstractNodeQueryProcessor<Collection<LabelDecorator>> {

    @Override
    public Collection<LabelDecorator> query(NodeQueryManager manager, NodeContext context) {
        Collection<LabelDecoratorFactory> factories = manager.query(context, BuiltinKeys.SELECTED_LABEL_DECORATOR_FACTORIES);
        if (factories.isEmpty()) {
            LabelDecorator truncation = new TreeTruncationDecoratorFactory(SWT.BOLD).create(manager, context);
            if (truncation != null)
                return Collections.singletonList(truncation);
            return Collections.emptyList();
        }

        Collection<LabelDecorator> decorators = new ArrayList<LabelDecorator>(factories.size() + 1);
        for (LabelDecoratorFactory f : factories) {
            assert f != null;
            LabelDecorator decorator = manager.query(context, new LabelDecoratorKey(f));
            if (decorator != null)
                decorators.add(decorator);
        }

        LabelDecorator truncation = new TreeTruncationDecoratorFactory(SWT.BOLD).create(manager, context);
        if (truncation != null)
            decorators.add(truncation);

        return decorators;
    }

    @Override
    public String toString() {
        return "LabelDecoratorsProcessor";
    }

    @Override
    public QueryKey<Collection<LabelDecorator>> getIdentifier() {
        return BuiltinKeys.LABEL_DECORATORS;
    }

}
