/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.services.IDisposable;
import org.simantics.browsing.ui.GraphExplorer;

public class DefaultExplorerSelectionListener implements ISelectionListener, IDisposable {

    private static final boolean DEBUG = false;

    IWorkbenchPart           owner;
    GraphExplorer            explorer;
    WorkbenchSelectionFilter filter;

    public DefaultExplorerSelectionListener(IWorkbenchPart owner, GraphExplorer explorer) {
        this(owner, explorer, ResourceSelectionFilter.FILTER);
    }

    public DefaultExplorerSelectionListener(IWorkbenchPart owner, GraphExplorer explorer, WorkbenchSelectionFilter filter) {
        this.owner = owner;
        this.explorer = explorer;
        this.filter = filter;
    }

    @Override
    public void dispose() {
        owner = null;
        explorer = null;
        filter = null;
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        // Always disregard own selections.
        if (part == owner)
            return;

        if (DEBUG)
            System.out.println("[" + owner + "] workbench selection changed: part=" + part + ", selection=" + selection);
        ISelection s = selection;
        WorkbenchSelectionFilter filter = this.filter;
        if (filter != null)
            s = filter.filterSelection(part, selection);

        if (s != null) {
            if (DEBUG) {
                System.out.println("** [" + owner + "] workbench selection changed: part=" + part + ", selection=" + selection);
                System.out.println("    SETTING NEW SELECTION");
            }
            GraphExplorer explorer = this.explorer;
            if(explorer != null && !explorer.isDisposed()) {
                IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            }
        } else {
            if (DEBUG)
                System.out.println("[" + owner + "] discarding selection: part=" + part + ", selection=" + selection);
        }
    }
}
