/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.content;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;

/**
 * @author Antti Villberg
 */
public interface LabelerFactory {

    /**
     * Returns a labeler for the specified input node context or
     * <code>null</code> if this factory is unable to provide a labeler for the
     * input. See {@link Labeler} for more on its purpose.
     * 
     * @param updater the updater that needs to be invoked through
     *        {@link PrimitiveQueryUpdater#scheduleReplace(NodeContext, org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey, Object)}
     *        to invalidate the result Labeler of this method if when the
     *        labeler changes in any way.
     * @param context the input for which to create a {@link Labeler}
     * @param key the key representing the primitive query that resulted in
     *        calling this {@link LabelerFactory}
     * @return a Labeler that describes labeling and label editing aspects of
     *         the specified input context or <code>null</code> if a labeler
     *         cannot be provided for any reason
     */
    Labeler create(PrimitiveQueryUpdater updater, NodeContext context, LabelerKey key);

}
