package org.simantics.browsing.ui.content;

import java.util.Collection;

public class CompositeImageDecorator implements ImageDecorator {

    Collection<ImageDecorator> decorators;

    public static final ImageDecorator ID = new ImageDecorator() {
        @Override
        public <Image> Image decorateImage(Image image, String column, int itemIndex) {
            return image;
        }
    };

    private CompositeImageDecorator(Collection<ImageDecorator> decorators) {
        this.decorators = decorators;
    }

    public static ImageDecorator create(Collection<ImageDecorator> decorators) {
        if(decorators.isEmpty())
            return ID;
        else if(decorators.size() == 1)
            return decorators.iterator().next();
        else
            return new CompositeImageDecorator(decorators);
    }

    @Override
    public <Image> Image decorateImage(Image image, String column, int itemIndex) {
        for(ImageDecorator decorator : decorators)
            image = decorator.decorateImage(image, column, itemIndex);
        return image;
    }

}
