/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.content;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;

/**
 * This interface can be used to determine a sorting order for the children of a
 * certain node. A single ComparableContextFactory is always used for the
 * children of a single parent node, i.e. a single sorting algorithm will always
 * be used to sort the children.
 * 
 * @author Antti Villberg
 */
public interface ComparableContextFactory {

    /**
     * Constructs {@link ComparableContext} instances from an array of
     * {@link NodeContext}s. The input array will be in the order in which the
     * viewpoint contributions happened to produce the {@link NodeContext}s in.
     * 
     * @param manager manager for performing the necessary queries to resolve
     *        the sorting order
     * @param parent the parent node of the children. May be used to carry
     *        constant data to guide the sorting process or just simply ignored.
     * @param children the set of child nodes to make into
     *        {@link ComparableContext} instances
     * @return the specified {@link NodeContext}s wrapped into
     *         {@link ComparableContext}s or <code>null</code> if no sorting is
     *         to be performed. The result array should be of the same size as
     *         the input array.
     */
    ComparableContext[] create(NodeQueryManager manager, NodeContext parent, NodeContext[] children);

}
