/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

/**
 * A SelectionFilter gives a {@link GraphExplorer} client primitive control over
 * what objects the explorer puts into the selections it provides.
 * 
 * <p>
 * Normally, a {@link GraphExplorer} selection contains only {@link NodeContext}
 * instances which exist separately for each separate visible UI element, like a
 * tree node. Presenting an implementation of this interface to an explorer will
 * cause the explorer to filter its selected NodeContexts, one by one, through
 * this interface.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see GraphExplorer#setSelectionFilter(SelectionFilter)
 */
public interface SelectionFilter {

    /**
     * @param context the context to filter
     * @return the filtered object
     */
    Object filter(NodeContext context);

}
