/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigHelper;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.config.DialogErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.grid.cell.AlternatingRowConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.menu.AbstractHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.SelectionFilter;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.internal.IGECache;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.DefaultCheckedStateProcessor;
import org.simantics.browsing.ui.common.processors.DefaultComparableChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultFinalChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImageDecoratorProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImagerFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImagerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelDecoratorProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelerFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultPrunedChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedImageDecoratorFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedLabelDecoratorFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedLabelerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedViewpointFactoryProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedViewpointProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointContributionProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointContributionsProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointProcessor;
import org.simantics.browsing.ui.common.processors.IsExpandedProcessor;
import org.simantics.browsing.ui.common.processors.NoSelectionRequestProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.common.state.ExplorerStates;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.nattable.GEColumnAccessor;
import org.simantics.browsing.ui.nattable.GEColumnHeaderDataProvider;
import org.simantics.browsing.ui.nattable.GEEditBindings;
import org.simantics.browsing.ui.nattable.GENatTableThemeConfiguration;
import org.simantics.browsing.ui.nattable.GETreeData;
import org.simantics.browsing.ui.nattable.GETreeLayer;
import org.simantics.browsing.ui.nattable.GETreeRowModel;
import org.simantics.browsing.ui.nattable.ImageTask;
import org.simantics.browsing.ui.nattable.NatTableColumnLayout;
import org.simantics.browsing.ui.nattable.NatTableSelectionAdaptor;
import org.simantics.browsing.ui.nattable.TreeNode;
import org.simantics.browsing.ui.nattable.override.DefaultTreeLayerConfiguration2;
import org.simantics.browsing.ui.swt.DefaultImageDecoratorsProcessor;
import org.simantics.browsing.ui.swt.DefaultIsExpandedProcessor;
import org.simantics.browsing.ui.swt.DefaultLabelDecoratorsProcessor;
import org.simantics.browsing.ui.swt.DefaultSelectedImagerProcessor;
import org.simantics.browsing.ui.swt.DefaultShowMaxChildrenProcessor;
import org.simantics.browsing.ui.swt.GraphExplorerImplBase;
import org.simantics.browsing.ui.swt.ImageLoaderJob;
import org.simantics.browsing.ui.swt.ViewerCellReference;
import org.simantics.browsing.ui.swt.ViewerRowReference;
import org.simantics.browsing.ui.swt.internal.Threads;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.jface.BasePostSelectionProvider;

public class NatTableGraphExplorer
extends GraphExplorerImplBase
implements GraphExplorer {
    public static final int DEFAULT_MAX_CHILDREN = 10000;
    private static final boolean DEBUG_SELECTION_LISTENERS = false;
    private static final boolean DEBUG = false;
    private Composite composite;
    private NatTable natTable;
    private GETreeLayer treeLayer;
    private DataLayer dataLayer;
    private ViewportLayer viewportLayer;
    private SelectionLayer selectionLayer;
    private GEColumnHeaderDataProvider columnHeaderDataProvider;
    private GEColumnAccessor columnAccessor;
    private DefaultRowHeaderDataLayer rowHeaderDataLayer;
    private DataLayer columnHeaderDataLayer;
    private DataLayer cornerDataLayer;
    private List<TreeNode> list = new ArrayList<TreeNode>();
    private NatTableSelectionAdaptor selectionAdaptor;
    private NatTableColumnLayout layout;
    LocalResourceManager localResourceManager;
    DeviceResourceManager resourceManager;
    private IThreadWorkQueue thread;
    final HashMap<NodeContext.CacheKey<?>, NodeQueryProcessor> processors = new HashMap();
    final HashMap<Object, PrimitiveQueryProcessor> primitiveProcessors = new HashMap();
    final HashMap<Class, DataSource> dataSources = new HashMap();
    FontDescriptor originalFont;
    protected ColorDescriptor originalForeground;
    protected ColorDescriptor originalBackground;
    private Color invalidModificationColor;
    private Column[] columns;
    private Map<String, Integer> columnKeyToIndex;
    private boolean columnsAreVisible = true;
    private NodeContext rootContext;
    private TreeNode rootNode;
    private StatePersistor persistor = null;
    private boolean editable = true;
    private boolean disposed = false;
    private final CopyOnWriteArrayList<FocusListener> focusListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MouseListener> mouseListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<KeyListener> keyListeners = new CopyOnWriteArrayList();
    private int autoExpandLevel = 0;
    private IServiceLocator serviceLocator;
    private IContextService contextService = null;
    private IFocusService focusService = null;
    private IContextActivation editingContext = null;
    GeViewerContext explorerContext = new GeViewerContext(this);
    private GraphExplorerPostSelectionProvider postSelectionProvider = new GraphExplorerPostSelectionProvider(this);
    private BasePostSelectionProvider selectionProvider = new BasePostSelectionProvider();
    private SelectionDataResolver selectionDataResolver;
    private SelectionFilter selectionFilter;
    private MapList<NodeContext, TreeNode> contextToNodeMap;
    private GraphExplorer.ModificationContext modificationContext = null;
    private boolean filterSelectionEdit = true;
    private boolean expand;
    private boolean verticalBarVisible = false;
    private BiFunction<GraphExplorer, Object[], Object[]> selectionTransformation = new BiFunction<GraphExplorer, Object[], Object[]>(){

        @Override
        public Object[] apply(GraphExplorer explorer, Object[] objects) {
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                AdaptableHintContext context = new AdaptableHintContext(new IHintContext.Key[]{SelectionHints.KEY_MAIN});
                context.setHint(SelectionHints.KEY_MAIN, objects[i]);
                result[i] = context;
                ++i;
            }
            return result;
        }
    };
    private TransientStateImpl transientState = new TransientStateImpl();
    private long focusGainedAt = 0L;
    private boolean visible = false;
    private Collection<TreeNode> selectedNodes = new ArrayList<TreeNode>();
    private NodeContext pendingRoot;
    private Set<String> uiContexts;
    int maxChildren = 10000;
    private HashSet<UpdateItem> pendingItems = new HashSet();
    private boolean updating = false;
    private int updateCounter = 0;
    final ScheduledExecutorService uiUpdateScheduler = ThreadUtils.getNonBlockingWorkExecutor();
    final ExecutorService queryUpdateScheduler = Threads.getExecutor();
    ImageLoaderJob imageLoaderJob;
    Map<TreeNode, ImageTask> imageTasks = new THashMap();

    public NatTableGraphExplorer(Composite parent) {
        this(parent, 2050);
    }

    public NatTableGraphExplorer(Composite parent, int style) {
        this.composite = parent;
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.resourceManager = new DeviceResourceManager((Device)parent.getDisplay());
        this.imageLoaderJob = new ImageLoaderJob((GraphExplorerImplBase)this);
        this.imageLoaderJob.setPriority(50);
        this.contextToNodeMap = new MapList();
        this.invalidModificationColor = (Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128)));
        this.thread = SWTThread.getThreadAccess((Widget)parent);
        int i = 0;
        while (i < 10) {
            this.explorerContext.activity.push(0);
            ++i;
        }
        this.originalFont = JFaceResources.getDefaultFontDescriptor();
        this.columns = new Column[0];
        this.createNatTable(style);
        this.layout = new NatTableColumnLayout(this.natTable, this.columnHeaderDataProvider, this.rowHeaderDataLayer);
        this.composite.setLayout((Layout)this.layout);
        this.setBasicListeners();
        this.setDefaultProcessors();
        this.natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NatTableGraphExplorer.this.doDispose();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: 
                    case 22: 
                    case 26: {
                        NatTableGraphExplorer.this.visible = true;
                        NatTableGraphExplorer.this.activate();
                        break;
                    }
                    case 23: 
                    case 27: {
                        NatTableGraphExplorer.this.visible = false;
                    }
                }
            }
        };
        this.natTable.addListener(26, listener);
        this.natTable.addListener(27, listener);
        this.natTable.addListener(22, listener);
        this.natTable.addListener(23, listener);
        this.natTable.addListener(9, listener);
        this.setColumns(new Column[]{new Column("single")});
    }

    protected void setBasicListeners() {
        this.natTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                NatTableGraphExplorer.this.focusGainedAt = (long)e.time & 0xFFFFFFFFL;
                for (FocusListener listener : NatTableGraphExplorer.this.focusListeners) {
                    listener.focusGained(e);
                }
            }

            public void focusLost(FocusEvent e) {
                for (FocusListener listener : NatTableGraphExplorer.this.focusListeners) {
                    listener.focusLost(e);
                }
            }
        });
        this.natTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                for (MouseListener listener : NatTableGraphExplorer.this.mouseListeners) {
                    listener.mouseDoubleClick(e);
                }
            }

            public void mouseDown(MouseEvent e) {
                for (MouseListener listener : NatTableGraphExplorer.this.mouseListeners) {
                    listener.mouseDown(e);
                }
            }

            public void mouseUp(MouseEvent e) {
                for (MouseListener listener : NatTableGraphExplorer.this.mouseListeners) {
                    listener.mouseUp(e);
                }
            }
        });
        this.natTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                for (KeyListener listener : NatTableGraphExplorer.this.keyListeners) {
                    listener.keyPressed(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                for (KeyListener listener : NatTableGraphExplorer.this.keyListeners) {
                    listener.keyReleased(e);
                }
            }
        });
        this.selectionAdaptor.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NatTableGraphExplorer.this.selectedNodes = AdaptionUtils.adaptToCollection((Object)event.getSelection(), TreeNode.class);
                Collection selectedContexts = AdaptionUtils.adaptToCollection((Object)event.getSelection(), NodeContext.class);
                NatTableGraphExplorer.this.selectionProvider.setAndFireSelection(NatTableGraphExplorer.this.constructSelection(selectedContexts.toArray(new NodeContext[selectedContexts.size()])));
            }
        });
        this.selectionAdaptor.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Collection selectedContexts = AdaptionUtils.adaptToCollection((Object)event.getSelection(), NodeContext.class);
                NatTableGraphExplorer.this.selectionProvider.firePostSelection(NatTableGraphExplorer.this.constructSelection(selectedContexts.toArray(new NodeContext[selectedContexts.size()])));
            }
        });
    }

    private void activate() {
        if (this.pendingRoot != null && !this.expand) {
            this.doSetRoot(this.pendingRoot);
            this.pendingRoot = null;
        }
    }

    private void doSetRoot(NodeContext root) {
        GeViewerContext newContext;
        Display display = this.composite.getDisplay();
        if (display.getThread() != Thread.currentThread()) {
            throw new RuntimeException("Invoke from SWT thread only");
        }
        if (this.isDisposed()) {
            return;
        }
        if (this.natTable.isDisposed()) {
            return;
        }
        if (root.getConstant(BuiltinKeys.INPUT) == null) {
            ErrorLogger.defaultLogError((String)("root node context does not contain BuiltinKeys.INPUT key. Node = " + root), (Throwable)new Exception("trace"));
            return;
        }
        if (this.rootNode != null) {
            this.rootNode.dispose();
        }
        GeViewerContext oldContext = this.explorerContext;
        this.explorerContext = newContext = new GeViewerContext(this);
        oldContext.safeDispose();
        this.clearPrimitiveProcessors();
        this.rootContext = root.getConstant(BuiltinKeys.IS_ROOT) != null ? root : NodeContextUtil.withConstant((NodeContext)root, (NodeContext.ConstantKey)BuiltinKeys.IS_ROOT, (Object)Boolean.TRUE);
        this.explorerContext.getCache().incRef(this.rootContext);
        this.initializeState();
        this.select(this.rootContext);
        this.rootNode = new TreeNode(this.rootContext, this.explorerContext);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NatTableGraphExplorer.this.rootNode != null) {
                    NatTableGraphExplorer.this.rootNode.updateChildren();
                    NatTableGraphExplorer.this.rootNode.setExpanded(true);
                    NatTableGraphExplorer.this.listReIndex();
                }
            }
        });
    }

    private synchronized void listReIndex() {
        for (TreeNode n : this.list) {
            n.setListIndex(-2);
        }
        this.list.clear();
        for (TreeNode c : this.rootNode.getChildren()) {
            this._insertToList(c);
        }
        this.natTable.refresh();
    }

    private void _insertToList(TreeNode n) {
        n.setListIndex(this.list.size());
        this.list.add(n);
        for (TreeNode c : n.getChildren()) {
            this._insertToList(c);
        }
    }

    public List<TreeNode> getItems() {
        return Collections.unmodifiableList(this.list);
    }

    private void initializeState() {
        if (this.persistor == null) {
            return;
        }
        ExplorerStates.scheduleRead((NodeContext)this.getRoot(), (StatePersistor)this.persistor).thenAccept(state -> {
            boolean bl = SWTUtils.asyncExec((Widget)this.natTable, () -> this.restoreState((ExplorerState)state));
        });
    }

    private void restoreState(ExplorerState state) {
        PrimitiveQueryProcessor processor = this.getPrimitiveProcessor(BuiltinKeys.IS_EXPANDED);
        if (processor instanceof DefaultIsExpandedProcessor) {
            DefaultIsExpandedProcessor isExpandedProcessor = (DefaultIsExpandedProcessor)processor;
            for (NodeContext expanded : state.expandedNodes) {
                isExpandedProcessor.replaceExpanded(expanded, true);
            }
        }
    }

    public NodeContext getRoot() {
        return this.rootContext;
    }

    public IThreadWorkQueue getThread() {
        return this.thread;
    }

    public NodeContext getParentContext(NodeContext context) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        List nodes = this.contextToNodeMap.getValuesUnsafe((Object)context);
        int i = 0;
        while (i < nodes.size()) {
            if (((TreeNode)nodes.get(i)).getParent() != null) {
                return ((TreeNode)nodes.get(i)).getParent().getContext();
            }
            ++i;
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISelectionProvider.class == adapter) {
            return (T)this.postSelectionProvider;
        }
        if (IPostSelectionProvider.class == adapter) {
            return (T)this.postSelectionProvider;
        }
        return null;
    }

    protected void setDefaultProcessors() {
        this.setProcessor((NodeQueryProcessor)new DefaultComparableChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultLabelDecoratorsProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultImageDecoratorsProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedLabelerProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultLabelerFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedImagerProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultImagerFactoriesProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultLabelerProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultCheckedStateProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultImagerProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultLabelDecoratorProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultImageDecoratorProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new NoSelectionRequestProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultFinalChildrenProcessor((GraphExplorer)this));
        this.setProcessor((NodeQueryProcessor)new DefaultPrunedChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedViewpointProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedLabelDecoratorFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedImageDecoratorFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultViewpointContributionsProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultViewpointProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultViewpointContributionProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultSelectedViewpointFactoryProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new TreeNodeIsExpandedProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultShowMaxChildrenProcessor());
    }

    public Column[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public void setColumnsVisible(boolean visible) {
        this.columnsAreVisible = visible;
    }

    public void setColumns(Column[] columns) {
        this.setColumns(columns, null);
    }

    public void setColumns(final Column[] columns, final Consumer<Map<Column, Object>> callback) {
        this.assertNotDisposed();
        this.checkUniqueColumnKeys(columns);
        Display d = this.composite.getDisplay();
        if (d.getThread() == Thread.currentThread()) {
            this.doSetColumns(columns, callback);
            this.natTable.refresh(true);
        } else {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NatTableGraphExplorer.this.natTable == null) {
                        return;
                    }
                    if (NatTableGraphExplorer.this.natTable.isDisposed()) {
                        return;
                    }
                    NatTableGraphExplorer.this.doSetColumns(columns, callback);
                    NatTableGraphExplorer.this.natTable.refresh();
                    NatTableGraphExplorer.this.natTable.getParent().layout();
                }
            });
        }
    }

    private void checkUniqueColumnKeys(Column[] cols) {
        HashSet<String> usedColumnKeys = new HashSet<String>();
        ArrayList<Column> duplicateColumns = new ArrayList<Column>();
        Column[] columnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (!usedColumnKeys.add(c.getKey())) {
                duplicateColumns.add(c);
            }
            ++n2;
        }
        if (!duplicateColumns.isEmpty()) {
            throw new IllegalArgumentException("All columns do not have unique keys: " + cols + ", overlapping: " + duplicateColumns);
        }
    }

    private void doSetColumns(Column[] cols, Consumer<Map<Column, Object>> callback) {
        HashMap<String, Integer> keyToIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < cols.length) {
            keyToIndex.put(cols[i].getKey(), i);
            ++i;
        }
        this.columns = Arrays.copyOf(cols, cols.length);
        this.columnKeyToIndex = keyToIndex;
        this.columnHeaderDataProvider.updateColumnSizes();
        HashMap map = new HashMap();
        int columnIndex = 0;
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            int width = column.getWidth();
            if (column.hasGrab()) {
                if (width < 0) {
                    width = 1;
                }
                this.layout.setColumnData(columnIndex, (ColumnLayoutData)new ColumnWeightData(column.getWeight(), width));
            } else {
                if (width < 0) {
                    width = 50;
                }
                this.layout.setColumnData(columnIndex, (ColumnLayoutData)new ColumnWeightData(this.columns.length > 1 ? 0 : 1, width));
            }
            ++columnIndex;
            ++n2;
        }
        if (callback != null) {
            callback.accept(map);
        }
    }

    int toSWT(Column.Align alignment) {
        switch (alignment) {
            case LEFT: {
                return 16384;
            }
            case CENTER: {
                return 0x1000000;
            }
            case RIGHT: {
                return 131072;
            }
        }
        throw new Error("unhandled alignment: " + alignment);
    }

    public <T> void setProcessor(NodeQueryProcessor<T> processor) {
        this.assertNotDisposed();
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        this.processors.put((NodeContext.CacheKey<?>)processor.getIdentifier(), (NodeQueryProcessor)processor);
    }

    public <T> void setPrimitiveProcessor(PrimitiveQueryProcessor<T> processor) {
        this.assertNotDisposed();
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        PrimitiveQueryProcessor<T> oldProcessor = this.primitiveProcessors.put(processor.getIdentifier(), processor);
        if (oldProcessor instanceof ProcessorLifecycle) {
            ((ProcessorLifecycle)oldProcessor).detached((GraphExplorer)this);
        }
        if (processor instanceof ProcessorLifecycle) {
            ((ProcessorLifecycle)processor).attached((GraphExplorer)this);
        }
    }

    public <T> void setDataSource(DataSource<T> provider) {
        this.assertNotDisposed();
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        this.dataSources.put(provider.getProvidedClass(), provider);
    }

    public <T> DataSource<T> removeDataSource(Class<T> forProvidedClass) {
        this.assertNotDisposed();
        if (forProvidedClass == null) {
            throw new IllegalArgumentException("null class");
        }
        return this.dataSources.remove(forProvidedClass);
    }

    public void setPersistor(StatePersistor persistor) {
        this.persistor = persistor;
    }

    public SelectionDataResolver getSelectionDataResolver() {
        return this.selectionDataResolver;
    }

    public void setSelectionDataResolver(SelectionDataResolver r) {
        this.selectionDataResolver = r;
    }

    public SelectionFilter getSelectionFilter() {
        return this.selectionFilter;
    }

    public void setSelectionFilter(SelectionFilter f) {
        this.selectionFilter = f;
    }

    protected ISelection constructSelection(NodeContext ... contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException("null contexts");
        }
        if (contexts.length == 0) {
            return StructuredSelection.EMPTY;
        }
        if (this.selectionFilter == null) {
            return new StructuredSelection(this.transformSelection(contexts));
        }
        return new StructuredSelection(this.transformSelection(NatTableGraphExplorer.filter(this.selectionFilter, contexts)));
    }

    protected Object[] transformSelection(Object[] objects) {
        return this.selectionTransformation.apply(this, objects);
    }

    protected static Object[] filter(SelectionFilter filter, NodeContext[] contexts) {
        int len = contexts.length;
        Object[] objects = new Object[len];
        int i = 0;
        while (i < len) {
            objects[i] = filter.filter(contexts[i]);
            ++i;
        }
        return objects;
    }

    public void setSelectionTransformation(BiFunction<GraphExplorer, Object[], Object[]> f) {
        this.selectionTransformation = f;
    }

    public ISelection getWidgetSelection() {
        return this.selectionAdaptor.getSelection();
    }

    public <T> void addListener(T listener) {
        if (listener instanceof FocusListener) {
            this.focusListeners.add((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            this.mouseListeners.add((MouseListener)listener);
        } else if (listener instanceof KeyListener) {
            this.keyListeners.add((KeyListener)listener);
        }
    }

    public <T> void removeListener(T listener) {
        if (listener instanceof FocusListener) {
            this.focusListeners.remove(listener);
        } else if (listener instanceof MouseListener) {
            this.mouseListeners.remove(listener);
        } else if (listener instanceof KeyListener) {
            this.keyListeners.remove(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionAdaptor.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionAdaptor.removeSelectionListener(listener);
    }

    public void setUIContexts(Set<String> contexts) {
        this.uiContexts = contexts;
    }

    public void setRoot(Object root) {
        if (this.uiContexts != null && this.uiContexts.size() == 1) {
            this.setRootContext0(NodeContextBuilder.buildWithData((Object[])new Object[]{BuiltinKeys.INPUT, root, BuiltinKeys.UI_CONTEXT, this.uiContexts.iterator().next()}));
        } else {
            this.setRootContext0(NodeContextBuilder.buildWithData((Object[])new Object[]{BuiltinKeys.INPUT, root}));
        }
    }

    public void setRootContext(NodeContext context) {
        this.setRootContext0(context);
    }

    private void setRoot(NodeContext context) {
        if (!this.visible) {
            this.pendingRoot = context;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NatTableGraphExplorer.this.natTable != null && !NatTableGraphExplorer.this.natTable.isDisposed()) {
                        NatTableGraphExplorer.this.natTable.redraw();
                    }
                }
            });
            return;
        }
        this.doSetRoot(context);
    }

    private void setRootContext0(final NodeContext context) {
        Assert.isNotNull((Object)context, (String)"root must not be null");
        if (this.isDisposed() || this.natTable.isDisposed()) {
            return;
        }
        Display display = this.natTable.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.setRoot(context);
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    NatTableGraphExplorer.this.setRoot(context);
                }
            });
        }
    }

    public void setFocus() {
        this.natTable.setFocus();
    }

    public <T> T getControl() {
        return (T)this.natTable;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("disposed");
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        this.editable = editable;
        Display display = this.natTable.getDisplay();
        this.natTable.setBackground(editable ? null : display.getSystemColor(22));
    }

    private void doDispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.rootNode != null) {
            this.rootNode.dispose();
            this.rootNode = null;
        }
        this.explorerContext.dispose();
        this.explorerContext = null;
        this.processors.clear();
        this.detachPrimitiveProcessors();
        this.primitiveProcessors.clear();
        this.dataSources.clear();
        this.pendingItems.clear();
        this.rootContext = null;
        this.mouseListeners.clear();
        this.selectionProvider.clearListeners();
        this.selectionProvider = null;
        this.selectionDataResolver = null;
        this.selectedNodes.clear();
        this.selectedNodes = null;
        this.selectionTransformation = null;
        this.originalFont = null;
        this.localResourceManager.dispose();
        this.localResourceManager = null;
        this.imageLoaderJob.dispose();
        this.imageLoaderJob.cancel();
        try {
            this.imageLoaderJob.join();
            this.imageLoaderJob = null;
        }
        catch (InterruptedException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.resourceManager.dispose();
        this.resourceManager = null;
        this.contextToNodeMap.clear();
        this.contextToNodeMap = null;
        if (this.postSelectionProvider != null) {
            this.postSelectionProvider.dispose();
            this.postSelectionProvider = null;
        }
        this.imageTasks = null;
        this.modificationContext = null;
        this.focusService = null;
        this.contextService = null;
        this.serviceLocator = null;
        this.columns = null;
        this.columnKeyToIndex.clear();
        this.columnKeyToIndex = null;
        this.treeLayer = null;
        this.dataLayer = null;
        this.viewportLayer = null;
        this.selectionLayer = null;
        this.columnHeaderDataProvider = null;
        this.columnAccessor = null;
        this.rowHeaderDataLayer = null;
        this.columnHeaderDataLayer = null;
        this.cornerDataLayer = null;
    }

    public boolean select(NodeContext context) {
        this.assertNotDisposed();
        if (context == null || context.equals(this.rootContext) || this.contextToNodeMap.getValuesUnsafe((Object)context).size() == 0) {
            StructuredSelection s = new StructuredSelection();
            this.selectionAdaptor.setSelection((ISelection)s);
            this.selectionProvider.setAndFireNonEqualSelection((ISelection)s);
            return true;
        }
        this.selectionAdaptor.setSelection((ISelection)new StructuredSelection(this.contextToNodeMap.getValuesUnsafe((Object)context).get(0)));
        return false;
    }

    public boolean select(TreeNode node) {
        this.assertNotDisposed();
        if (!this.list.contains(node)) {
            StructuredSelection s = new StructuredSelection();
            this.selectionAdaptor.setSelection((ISelection)s);
            this.selectionProvider.setAndFireNonEqualSelection((ISelection)s);
            return true;
        }
        this.selectionAdaptor.setSelection((ISelection)new StructuredSelection((Object)node));
        return false;
    }

    public void show(TreeNode node) {
        int index = node.getListIndex();
        int position = this.treeLayer.getRowPositionByIndex(index);
        if (position < 0) {
            this.treeLayer.expandToTreeRow(index);
            position = this.treeLayer.getRowPositionByIndex(index);
        }
        this.viewportLayer.moveRowPositionIntoViewport(position);
    }

    public boolean selectPath(Collection<NodeContext> contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException("Null list is not allowed");
        }
        if (contexts.isEmpty()) {
            throw new IllegalArgumentException("Empty list is not allowed");
        }
        return this.selectPathInternal(contexts.toArray(new NodeContext[contexts.size()]), 0);
    }

    private boolean selectPathInternal(NodeContext[] contexts, int position) {
        NodeContext head = contexts[position];
        if (position == contexts.length - 1) {
            return this.select(head);
        }
        this.setExpanded(head, true);
        if (!this.waitVisible(contexts[position + 1])) {
            return false;
        }
        return this.selectPathInternal(contexts, position + 1);
    }

    private boolean waitVisible(NodeContext context) {
        long start = System.nanoTime();
        while (!this.isVisible(context)) {
            Display.getCurrent().readAndDispatch();
            long duration = System.nanoTime() - start;
            if (!((double)duration > 1.0E10)) continue;
            return false;
        }
        return true;
    }

    public boolean isVisible(NodeContext context) {
        return this.contextToNodeMap.getValuesUnsafe((Object)context).size() != 0;
    }

    public GraphExplorer.TransientExplorerState getTransientState() {
        if (!this.thread.currentThreadAccess()) {
            throw new AssertionError((Object)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".getActiveColumn called from non SWT-thread: " + Thread.currentThread()));
        }
        return this.transientState;
    }

    public <T> T query(NodeContext context, NodeContext.CacheKey<T> key) {
        return this.explorerContext.cache.get(context, key);
    }

    public void setServiceLocator(IServiceLocator serviceLocator) {
        if (serviceLocator == null && PlatformUI.isWorkbenchRunning()) {
            serviceLocator = PlatformUI.getWorkbench();
        }
        this.serviceLocator = serviceLocator;
        if (serviceLocator != null) {
            this.contextService = (IContextService)serviceLocator.getService(IContextService.class);
            this.focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        }
    }

    private void detachPrimitiveProcessors() {
        for (PrimitiveQueryProcessor p : this.primitiveProcessors.values()) {
            if (!(p instanceof ProcessorLifecycle)) continue;
            ((ProcessorLifecycle)p).detached((GraphExplorer)this);
        }
    }

    private void clearPrimitiveProcessors() {
        for (PrimitiveQueryProcessor p : this.primitiveProcessors.values()) {
            if (!(p instanceof ProcessorLifecycle)) continue;
            ((ProcessorLifecycle)p).clear();
        }
    }

    public void setExpanded(NodeContext context, boolean expanded) {
        for (TreeNode n : this.contextToNodeMap.getValues((Object)context)) {
            if (expanded) {
                this.treeLayer.expandTreeRow(n.getListIndex());
                continue;
            }
            this.treeLayer.collapseTreeRow(n.getListIndex());
        }
    }

    public void setAutoExpandLevel(int level) {
        this.autoExpandLevel = level;
        this.treeLayer.expandAllToLevel(level);
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }

    public int getMaxChildren(NodeQueryManager manager, NodeContext context) {
        Integer result = (Integer)manager.query(context, BuiltinKeys.SHOW_MAX_CHILDREN);
        if (result != null) {
            if (result < 0) {
                throw new AssertionError((Object)("BuiltinKeys.SHOW_MAX_CHILDREN query must never return < 0, got " + result));
            }
            return result;
        }
        return this.maxChildren;
    }

    public <T> NodeQueryProcessor<T> getProcessor(NodeContext.QueryKey<T> key) {
        return this.explorerContext.getProcessor(key);
    }

    public <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(NodeContext.PrimitiveQueryKey<T> key) {
        return this.explorerContext.getPrimitiveProcessor(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(TreeNode element, int columnIndex) {
        if (this.natTable.isDisposed()) {
            return;
        }
        if (element != null && element.isDisposed()) {
            return;
        }
        HashSet<UpdateItem> hashSet = this.pendingItems;
        synchronized (hashSet) {
            this.pendingItems.add(new UpdateItem(element, columnIndex));
            if (this.updating) {
                return;
            }
            ++this.updateCounter;
            this.scheduleUpdater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(TreeNode element) {
        if (this.natTable.isDisposed()) {
            return;
        }
        if (element != null && element.isDisposed()) {
            return;
        }
        HashSet<UpdateItem> hashSet = this.pendingItems;
        synchronized (hashSet) {
            this.pendingItems.add(new UpdateItem(element));
            if (this.updating) {
                return;
            }
            ++this.updateCounter;
            this.scheduleUpdater();
        }
    }

    boolean scheduleUpdater() {
        if (this.natTable.isDisposed()) {
            return false;
        }
        if (!this.pendingItems.isEmpty()) {
            int activity = this.explorerContext.activityInt;
            long delay = 30L;
            if (activity >= 100) {
                delay = activity < 1000 ? 500L : 3000L;
            }
            this.updateCounter = 0;
            this.uiUpdateScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    if (NatTableGraphExplorer.this.natTable == null || NatTableGraphExplorer.this.natTable.isDisposed()) {
                        return;
                    }
                    if (NatTableGraphExplorer.this.updateCounter > 0) {
                        NatTableGraphExplorer.this.updateCounter = 0;
                        NatTableGraphExplorer.this.uiUpdateScheduler.schedule(this, 50L, TimeUnit.MILLISECONDS);
                    } else {
                        NatTableGraphExplorer.this.natTable.getDisplay().asyncExec((Runnable)new UpdateRunner(NatTableGraphExplorer.this, NatTableGraphExplorer.this.explorerContext));
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.updating = true;
            return true;
        }
        return false;
    }

    public String startEditing(NodeContext context, String columnKey) {
        Integer columnIndex;
        this.assertNotDisposed();
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        if (columnKey.startsWith("#")) {
            columnKey = columnKey.substring(1);
        }
        if ((columnIndex = this.columnKeyToIndex.get(columnKey)) == null) {
            return "Rename not supported for selection";
        }
        return "Rename not supported for selection";
    }

    public String startEditing(String columnKey) {
        ISelection selection = this.postSelectionProvider.getSelection();
        if (selection == null) {
            return "Rename not supported for selection";
        }
        NodeContext context = (NodeContext)ISelectionUtils.filterSingleSelection((Object)selection, NodeContext.class);
        if (context == null) {
            return "Rename not supported for selection";
        }
        return this.startEditing(context, columnKey);
    }

    public void setSelection(ISelection selection, boolean forceControlUpdate) {
        this.assertNotDisposed();
        boolean equalsOld = this.selectionProvider.selectionEquals(selection);
        if (equalsOld && !forceControlUpdate) {
            this.selectionProvider.setSelection(selection);
        } else {
            Collection coll = AdaptionUtils.adaptToCollection((Object)selection, NodeContext.class);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            for (NodeContext c : coll) {
                List match = this.contextToNodeMap.getValuesUnsafe((Object)c);
                if (match.size() <= 0) continue;
                nodes.add((TreeNode)match.get(0));
            }
            StructuredSelection sel = new StructuredSelection(nodes.toArray());
            if (coll.size() == 0) {
                return;
            }
            if (this.natTable.isDisposed()) {
                return;
            }
            Display d = this.natTable.getDisplay();
            if (d.getThread() == Thread.currentThread()) {
                this.selectionAdaptor.setSelection((ISelection)sel);
            } else {
                d.asyncExec(new Runnable((ISelection)sel){
                    private final /* synthetic */ ISelection val$sel;
                    {
                        this.val$sel = iSelection;
                    }

                    @Override
                    public void run() {
                        if (NatTableGraphExplorer.this.natTable.isDisposed()) {
                            return;
                        }
                        NatTableGraphExplorer.this.selectionAdaptor.setSelection(this.val$sel);
                    }
                });
            }
        }
    }

    public void setModificationContext(GraphExplorer.ModificationContext modificationContext) {
        this.modificationContext = modificationContext;
    }

    public static double getDisplayScale() {
        Point dpi = Display.getCurrent().getDPI();
        return (double)dpi.x / 96.0;
    }

    private void createNatTable(int style) {
        GETreeData treeData = new GETreeData(this.list);
        GETreeRowModel<TreeNode> treeRowModel = new GETreeRowModel<TreeNode>(treeData);
        this.columnAccessor = new GEColumnAccessor(this);
        ListDataProvider dataProvider = new ListDataProvider(this.list, (IColumnAccessor)this.columnAccessor);
        this.dataLayer = new DataLayer((IDataProvider)dataProvider);
        this.dataLayer.setRowsResizableByDefault(false);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)dataProvider);
        this.rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        this.columnHeaderDataProvider = new GEColumnHeaderDataProvider(this, this.dataLayer);
        this.columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)this.columnHeaderDataProvider);
        this.columnHeaderDataProvider.updateColumnSizes();
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.dataLayer);
        ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        this.treeLayer = new GETreeLayer((IUniqueIndexLayer)columnHideShowLayer, treeRowModel, false);
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.treeLayer);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.columnHeaderDataLayer, (ILayer)this.viewportLayer, this.selectionLayer);
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)this.columnHeaderDataLayer);
        this.columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)this.rowHeaderDataLayer, (ILayer)this.viewportLayer, this.selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        this.cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)this.cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)this.viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer, false);
        gridLayer.setConfigLabelAccumulatorForRegion("BODY", (IConfigLabelAccumulator)new RelativeAlternatingRowConfigLabelAccumulator());
        gridLayer.addConfiguration((IConfiguration)new DefaultEditConfiguration());
        gridLayer.addConfiguration((IConfiguration)new GEEditBindings());
        this.natTable = new NatTable(this.composite, (ILayer)gridLayer, false);
        this.natTable.addConfiguration((IConfiguration)new NatTableHeaderMenuConfiguration(this.natTable));
        this.natTable.addConfiguration((IConfiguration)new DefaultTreeLayerConfiguration2(this.treeLayer));
        this.natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.natTable.addConfiguration((IConfiguration)new GENatTableThemeConfiguration(treeData, style));
        this.natTable.addConfiguration((IConfiguration)new NatTableHeaderMenuConfiguration(this.natTable));
        this.natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)new IEditableRule(){

                    public boolean isEditable(ILayerCell cell, IConfigRegistry configRegistry) {
                        int col = cell.getColumnIndex();
                        int row = cell.getRowIndex();
                        TreeNode node = (this).NatTableGraphExplorer.this.list.get(row);
                        Labeler.Modifier modifier = NatTableGraphExplorer.this.getModifier(node, col);
                        return modifier != null;
                    }

                    public boolean isEditable(int columnIndex, int rowIndex) {
                        return false;
                    }
                });
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new AdaptableCellEditor());
                configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_HANDLER, (Object)new DialogErrorHandling(), "EDIT");
                configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new DialogErrorHandling(), "EDIT");
                configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new AdaptableDataValidator(), "EDIT");
                Style conversionErrorStyle = new Style();
                conversionErrorStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
                conversionErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
                configRegistry.registerConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, (Object)conversionErrorStyle, "EDIT");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter(), "EDIT");
            }
        });
        if ((style & 0x800) > 0) {
            this.natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        }
        this.natTable.configure();
        this.selectionAdaptor = new NatTableSelectionAdaptor(this.natTable, this.selectionLayer, treeData);
    }

    Labeler.Modifier getModifier(TreeNode element, int columnIndex) {
        NodeContext context;
        GENodeQueryManager manager = element.getManager();
        Labeler labeler = (Labeler)manager.query(context = element.getContext(), BuiltinKeys.SELECTED_LABELER);
        if (labeler == null) {
            return null;
        }
        Column column = this.columns[columnIndex];
        return labeler.getModifier(this.modificationContext, column.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueImageTask(TreeNode node, ImageTask task) {
        Map<TreeNode, ImageTask> map = this.imageTasks;
        synchronized (map) {
            this.imageTasks.put(node, task);
        }
        this.imageLoaderJob.scheduleIfNecessary(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus setPendingImages(IProgressMonitor monitor) {
        ImageTask[] tasks = null;
        Map<TreeNode, ImageTask> map = this.imageTasks;
        synchronized (map) {
            tasks = this.imageTasks.values().toArray(new ImageTask[this.imageTasks.size()]);
            this.imageTasks.clear();
        }
        IStatus status = null;
        ImageTask[] imageTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTask task = imageTaskArray[n2];
            Object desc = task.descsOrImage;
            if (desc instanceof ImageDescriptor) {
                try {
                    task.descsOrImage = desc = this.resourceManager.get((DeviceResourceDescriptor)((ImageDescriptor)desc));
                }
                catch (DeviceResourceException e) {
                    if (status == null) {
                        status = new MultiStatus("org.simantics.browsing.ui.swt", 0, "Problems loading images:", null);
                    }
                    status.add((IStatus)new Status(4, "org.simantics.browsing.ui.swt", "Image descriptor loading failed: " + desc, (Throwable)e));
                }
            }
            ++n2;
        }
        final ImageTask[] _tasks = tasks;
        this.thread.asyncExec(new Runnable(){

            @Override
            public void run() {
                NatTableGraphExplorer.this.setImages(_tasks);
            }
        });
        return status != null ? status : Status.OK_STATUS;
    }

    void setImages(ImageTask[] tasks) {
        ImageTask[] imageTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTask task = imageTaskArray[n2];
            if (task != null) {
                this.setImage(task);
            }
            ++n2;
        }
    }

    void setImage(ImageTask task) {
        if (!task.node.isDisposed()) {
            this.update(task.node, 0);
        }
    }

    private static void printDebug(NatTableGraphExplorer ge) {
        ge.printTree(ge.rootNode, 0);
        System.out.println("Expanded");
        for (TreeNode n : ge.treeLayer.expanded) {
            System.out.println(n);
        }
        System.out.println("Expanded end");
        System.out.println("Hidden ");
        Iterator<Object> iterator = ge.treeLayer.getHiddenRowIndexes().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            System.out.print(String.valueOf(i) + " ");
        }
        System.out.println();
    }

    private void printTree(TreeNode node, int depth) {
        String s = "";
        int i = 0;
        while (i < depth) {
            s = String.valueOf(s) + "  ";
            ++i;
        }
        s = String.valueOf(s) + node;
        System.out.println(s);
        int d = depth + 1;
        for (TreeNode n : node.getChildren()) {
            this.printTree(n, d);
        }
    }

    public Object getClicked(Object event) {
        MouseEvent e = (MouseEvent)event;
        NatTable cfr_ignored_0 = (NatTable)e.getSource();
        Point point = new Point(e.x, e.y);
        int y = this.natTable.getRowPositionByY(point.y);
        int x = this.natTable.getColumnPositionByX(point.x);
        if (x < 0 | y <= 0) {
            return null;
        }
        return this.list.get(y - 1);
    }

    private class AdaptableCellEditor
    implements ICellEditor {
        ICellEditor editor;

        private AdaptableCellEditor() {
        }

        public Control activateCell(Composite parent, Object originalCanonicalValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
            int col = cell.getColumnIndex();
            int row = cell.getRowIndex();
            TreeNode node = NatTableGraphExplorer.this.list.get(row);
            Labeler.Modifier modifier = NatTableGraphExplorer.this.getModifier(node, col);
            if (modifier == null) {
                return null;
            }
            this.editor = null;
            if (modifier instanceof Labeler.DialogModifier) {
                Labeler.DialogModifier mod = (Labeler.DialogModifier)modifier;
                this.editor = new DialogCellEditor(node, col, mod);
            } else if (modifier instanceof Labeler.CustomModifier) {
                Labeler.CustomModifier mod = (Labeler.CustomModifier)modifier;
                this.editor = new CustomCellEditor(node, col, mod);
            } else if (modifier instanceof Labeler.EnumerationModifier) {
                Labeler.EnumerationModifier mod = (Labeler.EnumerationModifier)modifier;
                this.editor = new ComboBoxCellEditor(mod.getValues());
            } else {
                this.editor = new TextCellEditor();
            }
            return this.editor.activateCell(parent, originalCanonicalValue, editMode, editHandler, cell, configRegistry);
        }

        public int getColumnIndex() {
            return this.editor.getColumnIndex();
        }

        public int getRowIndex() {
            return this.editor.getRowIndex();
        }

        public int getColumnPosition() {
            return this.editor.getColumnPosition();
        }

        public int getRowPosition() {
            return this.editor.getRowPosition();
        }

        public Object getEditorValue() {
            return this.editor.getEditorValue();
        }

        public void setEditorValue(Object value) {
            this.editor.setEditorValue(value);
        }

        public Object getCanonicalValue() {
            return this.editor.getCanonicalValue();
        }

        public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
            return this.editor.getCanonicalValue();
        }

        public void setCanonicalValue(Object canonicalValue) {
            this.editor.setCanonicalValue(canonicalValue);
        }

        public boolean validateCanonicalValue(Object canonicalValue) {
            return this.editor.validateCanonicalValue(canonicalValue);
        }

        public boolean validateCanonicalValue(Object canonicalValue, IEditErrorHandler validationErrorHandler) {
            return this.editor.validateCanonicalValue(canonicalValue, validationErrorHandler);
        }

        public boolean commit(SelectionLayer.MoveDirectionEnum direction) {
            return this.editor.commit(direction);
        }

        public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
            return this.editor.commit(direction, closeAfterCommit);
        }

        public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit, boolean skipValidation) {
            return this.editor.commit(direction, closeAfterCommit, skipValidation);
        }

        public void close() {
            this.editor.close();
        }

        public boolean isClosed() {
            return this.editor.isClosed();
        }

        public Control getEditorControl() {
            return this.editor.getEditorControl();
        }

        public Control createEditorControl(Composite parent) {
            return this.editor.createEditorControl(parent);
        }

        public boolean openInline(IConfigRegistry configRegistry, List<String> configLabels) {
            return EditConfigHelper.openInline((IConfigRegistry)configRegistry, configLabels);
        }

        public boolean supportMultiEdit(IConfigRegistry configRegistry, List<String> configLabels) {
            return this.editor.supportMultiEdit(configRegistry, configLabels);
        }

        public boolean openMultiEditDialog() {
            return this.editor.openMultiEditDialog();
        }

        public boolean openAdjacentEditor() {
            return this.editor.openAdjacentEditor();
        }

        public boolean activateAtAnyPosition() {
            return true;
        }

        public boolean activateOnTraversal(IConfigRegistry configRegistry, List<String> configLabels) {
            return this.editor.activateOnTraversal(configRegistry, configLabels);
        }

        public void addEditorControlListeners() {
            this.editor.addEditorControlListeners();
        }

        public void removeEditorControlListeners() {
            this.editor.removeEditorControlListeners();
        }

        public Rectangle calculateControlBounds(Rectangle cellBounds) {
            return this.editor.calculateControlBounds(cellBounds);
        }
    }

    private class AdaptableDataValidator
    implements IDataValidator {
        private AdaptableDataValidator() {
        }

        public boolean validate(ILayerCell cell, IConfigRegistry configRegistry, Object newValue) {
            int col = cell.getColumnIndex();
            int row = cell.getRowIndex();
            return this.validate(col, row, newValue);
        }

        public boolean validate(int col, int row, Object newValue) {
            TreeNode node = NatTableGraphExplorer.this.list.get(row);
            Labeler.Modifier modifier = NatTableGraphExplorer.this.getModifier(node, col);
            if (modifier == null) {
                return false;
            }
            String err = modifier.isValid(newValue != null ? newValue.toString() : "");
            if (err == null) {
                return true;
            }
            throw new ValidationFailedException(err);
        }
    }

    private class CustomCellEditor
    extends AbstractCellEditor {
        TreeNode node;
        Labeler.CustomModifier customModifier;
        Control control;
        int column;

        public CustomCellEditor(TreeNode node, int column, Labeler.CustomModifier customModifier) {
            this.customModifier = customModifier;
            this.node = node;
            this.column = column;
        }

        public Object getEditorValue() {
            return this.customModifier.getValue();
        }

        public void setEditorValue(Object value) {
            this.customModifier.modify(value.toString());
        }

        public Control getEditorControl() {
            return this.control;
        }

        public Control createEditorControl(Composite parent) {
            return (Control)this.customModifier.createControl((Object)parent, null, this.column, this.node.getContext());
        }

        protected Control activateCell(Composite parent, Object originalCanonicalValue) {
            this.control = this.createEditorControl(parent);
            return this.control;
        }
    }

    private class DialogCellEditor
    extends AbstractDialogCellEditor {
        TreeNode node;
        Labeler.DialogModifier dialogModifier;
        int column;
        String res = null;
        Semaphore sem;
        boolean closed = false;

        public DialogCellEditor(TreeNode node, int column, Labeler.DialogModifier dialogModifier) {
            this.dialogModifier = dialogModifier;
            this.node = node;
            this.column = column;
        }

        public int open() {
            this.sem = new Semaphore(1);
            Consumer<String> callback = result -> {
                this.res = result;
                this.sem.release();
            };
            String status = this.dialogModifier.query((Object)this.parent.getShell(), null, this.column, this.node.getContext(), callback);
            if (status != null) {
                this.closed = true;
                return 1;
            }
            try {
                this.sem.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.closed = true;
            return 0;
        }

        public Labeler.DialogModifier createDialogInstance() {
            this.closed = false;
            return this.dialogModifier;
        }

        public Object getDialogInstance() {
            return (Labeler.DialogModifier)this.dialog;
        }

        public void close() {
        }

        public Object getEditorValue() {
            return null;
        }

        public void setEditorValue(Object value) {
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    private static class DummyCache
    extends GECache2 {
        private DummyCache() {
        }

        @Override
        public <T> IGECache.IGECacheEntry getEntry(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public <T> IGECache.IGECacheEntry put(NodeContext context, NodeContext.CacheKey<T> key, T value) {
            return null;
        }

        @Override
        public <T> void putTreeReference(NodeContext context, NodeContext.CacheKey<T> key, UIElementReference reference) {
        }

        @Override
        public <T> T get(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public <T> Set<UIElementReference> getTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public <T> void remove(NodeContext context, NodeContext.CacheKey<T> key) {
        }

        @Override
        public <T> Set<UIElementReference> removeTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            return null;
        }

        @Override
        public boolean isShown(NodeContext context) {
            return false;
        }

        @Override
        public void incRef(NodeContext context) {
        }

        @Override
        public void decRef(NodeContext context) {
        }

        @Override
        public void dispose() {
            super.dispose();
        }
    }

    public static class GECache2
    implements IGECache {
        final HashMap<GECacheKey, IGECache.IGECacheEntry> entries = new HashMap();
        final HashMap<GECacheKey, Set<UIElementReference>> treeReferences = new HashMap();
        final HashMap<NodeContext, Set<GECacheKey>> keyRefs = new HashMap();
        NodeContext getNC = new NodeContext(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public <T> T getConstant(NodeContext.ConstantKey<T> key) {
                return null;
            }

            public Set<NodeContext.ConstantKey<?>> getKeys() {
                return Collections.emptySet();
            }
        };
        NodeContext.CacheKey<?> getCK = new NodeContext.CacheKey<Object>(){

            public Object processorIdenfitier() {
                return this;
            }
        };
        GECacheKey getKey = new GECacheKey(this.getNC, this.getCK);
        private TObjectIntHashMap<NodeContext> references = new TObjectIntHashMap();

        private void addKey(GECacheKey key) {
            Set<GECacheKey> refs = this.keyRefs.get(key.context);
            if (refs != null) {
                refs.add(key);
            } else {
                refs = new HashSet<GECacheKey>();
                refs.add(key);
                this.keyRefs.put(key.context, refs);
            }
        }

        private void removeKey(GECacheKey key) {
            Set<GECacheKey> refs = this.keyRefs.get(key.context);
            if (refs != null) {
                refs.remove(key);
            }
        }

        public <T> IGECache.IGECacheEntry put(NodeContext context, NodeContext.CacheKey<T> key, T value) {
            IGECache.GECacheEntry entry = new IGECache.GECacheEntry(context, key, value);
            GECacheKey gekey = new GECacheKey(context, key);
            this.entries.put(gekey, (IGECache.IGECacheEntry)entry);
            this.addKey(gekey);
            return entry;
        }

        public <T> T get(NodeContext context, NodeContext.CacheKey<T> key) {
            this.getKey.setValues(context, key);
            IGECache.IGECacheEntry entry = this.entries.get(this.getKey);
            if (entry == null) {
                return null;
            }
            return (T)entry.getValue();
        }

        public <T> IGECache.IGECacheEntry getEntry(NodeContext context, NodeContext.CacheKey<T> key) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            return this.entries.get(this.getKey);
        }

        public <T> void remove(NodeContext context, NodeContext.CacheKey<T> key) {
            this.getKey.setValues(context, key);
            this.entries.remove(this.getKey);
            this.removeKey(this.getKey);
        }

        public <T> Set<UIElementReference> getTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            return this.treeReferences.get(this.getKey);
        }

        public <T> void putTreeReference(NodeContext context, NodeContext.CacheKey<T> key, UIElementReference reference) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            Set<UIElementReference> refs = this.treeReferences.get(this.getKey);
            if (refs != null) {
                refs.add(reference);
            } else {
                refs = new HashSet<UIElementReference>(4);
                refs.add(reference);
                GECacheKey gekey = new GECacheKey(this.getKey);
                this.treeReferences.put(gekey, refs);
                this.addKey(gekey);
            }
        }

        public <T> Set<UIElementReference> removeTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
            assert (context != null);
            assert (key != null);
            this.getKey.setValues(context, key);
            this.removeKey(this.getKey);
            return this.treeReferences.remove(this.getKey);
        }

        public boolean isShown(NodeContext context) {
            return this.references.get((Object)context) > 0;
        }

        public void incRef(NodeContext context) {
            int exist = this.references.get((Object)context);
            this.references.put((Object)context, exist + 1);
        }

        public void decRef(NodeContext context) {
            int exist = this.references.get((Object)context);
            this.references.put((Object)context, exist - 1);
            if (exist == 1) {
                this.references.remove((Object)context);
            }
        }

        public void dispose() {
            this.references.clear();
            this.entries.clear();
            this.treeReferences.clear();
            this.keyRefs.clear();
        }

        public void dispose(NodeContext context) {
            Set<GECacheKey> keys = this.keyRefs.remove(context);
            if (keys != null) {
                for (GECacheKey key : keys) {
                    this.entries.remove(key);
                    this.treeReferences.remove(key);
                }
            }
        }
    }

    private static final class GECacheKey {
        private NodeContext context;
        private NodeContext.CacheKey<?> key;

        GECacheKey(NodeContext context, NodeContext.CacheKey<?> key) {
            this.context = context;
            this.key = key;
            if (context == null || key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
        }

        GECacheKey(GECacheKey other) {
            this.context = other.context;
            this.key = other.key;
            if (this.context == null || this.key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
        }

        void setValues(NodeContext context, NodeContext.CacheKey<?> key) {
            this.context = context;
            this.key = key;
            if (context == null || key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
        }

        public int hashCode() {
            return this.context.hashCode() | this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            GECacheKey i = (GECacheKey)object;
            return this.key.equals(i.key) && this.context.equals(i.context);
        }
    }

    public static class GeViewerContext
    extends AbstractDisposable
    implements IGraphExplorerContext {
        private NatTableGraphExplorer ge;
        int queryIndent = 0;
        GECache2 cache = new GECache2();
        AtomicBoolean propagating = new AtomicBoolean(false);
        Object propagateList = new Object();
        Object propagate = new Object();
        List<Runnable> scheduleList = new ArrayList<Runnable>();
        final Deque<Integer> activity = new LinkedList<Integer>();
        int activityInt = 0;
        AtomicReference<Runnable> currentQueryUpdater = new AtomicReference();
        Map<NodeContext, Boolean> autoExpanded = new WeakHashMap<NodeContext, Boolean>();
        Runnable QUERY_UPDATE_SCHEDULER = new Runnable(){

            @Override
            public void run() {
                Runnable r = currentQueryUpdater.getAndSet(null);
                if (r != null) {
                    r.run();
                }
            }
        };

        public GeViewerContext(NatTableGraphExplorer ge) {
            this.ge = ge;
        }

        public MapList<NodeContext, TreeNode> getContextToNodeMap() {
            if (this.ge == null) {
                return null;
            }
            return this.ge.contextToNodeMap;
        }

        public NatTableGraphExplorer getGe() {
            return this.ge;
        }

        protected void doDispose() {
            this.autoExpanded.clear();
        }

        public IGECache getCache() {
            return this.cache;
        }

        public int queryIndent() {
            return this.queryIndent;
        }

        public int queryIndent(int offset) {
            this.queryIndent += offset;
            return this.queryIndent;
        }

        public <T> NodeQueryProcessor<T> getProcessor(Object o) {
            if (this.ge == null) {
                return null;
            }
            return this.ge.processors.get(o);
        }

        public <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(Object o) {
            return this.ge.primitiveProcessors.get(o);
        }

        public <T> DataSource<T> getDataSource(Class<T> clazz) {
            return this.ge.dataSources.get(clazz);
        }

        public void update(UIElementReference ref) {
            if (ref instanceof ViewerCellReference) {
                ViewerCellReference tiref = (ViewerCellReference)ref;
                Object element = tiref.getElement();
                int columnIndex = tiref.getColumn();
                this.ge.update((TreeNode)element, columnIndex);
            } else if (ref instanceof ViewerRowReference) {
                ViewerRowReference rref = (ViewerRowReference)ref;
                Object element = rref.getElement();
                this.ge.update((TreeNode)element);
            } else {
                throw new IllegalArgumentException("Ui Reference is unknkown " + ref);
            }
        }

        public Object getPropagateLock() {
            return this.propagate;
        }

        public Object getPropagateListLock() {
            return this.propagateList;
        }

        public boolean isPropagating() {
            return this.propagating.get();
        }

        public void setPropagating(boolean b) {
            this.propagating.set(b);
        }

        public List<Runnable> getScheduleList() {
            return this.scheduleList;
        }

        public void setScheduleList(List<Runnable> list) {
            this.scheduleList = list;
        }

        public Deque<Integer> getActivity() {
            return this.activity;
        }

        public void setActivityInt(int i) {
            this.activityInt = i;
        }

        public int getActivityInt() {
            return this.activityInt;
        }

        public void scheduleQueryUpdate(Runnable r) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            if (this.currentQueryUpdater.compareAndSet(null, r)) {
                this.ge.queryUpdateScheduler.execute(this.QUERY_UPDATE_SCHEDULER);
            }
        }

        public void dispose() {
            this.cache.dispose();
            this.cache = new DummyCache();
            this.scheduleList.clear();
            this.autoExpanded.clear();
            this.autoExpanded = null;
            this.ge = null;
        }
    }

    private static class GraphExplorerPostSelectionProvider
    implements IPostSelectionProvider {
        private NatTableGraphExplorer ge;

        GraphExplorerPostSelectionProvider(NatTableGraphExplorer ge) {
            this.ge = ge;
        }

        void dispose() {
            this.ge = null;
        }

        public void setSelection(ISelection selection) {
            if (this.ge == null) {
                return;
            }
            this.ge.setSelection(selection, false);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            this.ge.selectionProvider.removeSelectionChangedListener(listener);
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".addPostSelectionChangedListener called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.isDisposed()) {
                System.out.println("Client BUG: GraphExplorerImpl is disposed in addPostSelectionChangedListener: " + listener);
                return;
            }
            this.ge.selectionProvider.addPostSelectionChangedListener(listener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            this.ge.selectionProvider.removePostSelectionChangedListener(listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".addSelectionChangedListener called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.natTable.isDisposed() || this.ge.selectionProvider == null) {
                System.out.println("Client BUG: GraphExplorerImpl is disposed in addSelectionChangedListener: " + listener);
                return;
            }
            this.ge.selectionProvider.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (this.ge == null) {
                return StructuredSelection.EMPTY;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".getSelection called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.natTable.isDisposed() || this.ge.selectionProvider == null) {
                return StructuredSelection.EMPTY;
            }
            return this.ge.selectionProvider.getSelection();
        }
    }

    static class ModifierValidator
    implements ICellEditorValidator {
        private Labeler.Modifier modifier;

        public ModifierValidator(Labeler.Modifier modifier) {
            this.modifier = modifier;
        }

        public String isValid(Object value) {
            return this.modifier.isValid((String)value);
        }
    }

    private class NatTableHeaderMenuConfiguration
    extends AbstractHeaderMenuConfiguration {
        public NatTableHeaderMenuConfiguration(NatTable natTable) {
            super(natTable);
        }

        protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
            return super.createColumnHeaderMenu(natTable).withHideColumnMenuItem().withShowAllColumnsMenuItem().withAutoResizeSelectedColumnsMenuItem();
        }

        protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
            return super.createCornerMenu(natTable).withShowAllColumnsMenuItem();
        }

        protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
            return super.createRowHeaderMenu(natTable);
        }
    }

    private static class RelativeAlternatingRowConfigLabelAccumulator
    extends AlternatingRowConfigLabelAccumulator {
        private RelativeAlternatingRowConfigLabelAccumulator() {
        }

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            configLabels.addLabel(rowPosition % 2 == 0 ? "EVEN_BODY" : "ODD_BODY");
        }
    }

    static class TransientStateImpl
    implements GraphExplorer.TransientExplorerState {
        private Integer activeColumn = null;

        TransientStateImpl() {
        }

        public synchronized Integer getActiveColumn() {
            return this.activeColumn;
        }

        public synchronized void setActiveColumn(Integer column) {
            this.activeColumn = column;
        }
    }

    private class TreeNodeIsExpandedProcessor
    extends AbstractPrimitiveQueryProcessor<Boolean>
    implements IsExpandedProcessor,
    ProcessorLifecycle {
        private final HashSet<NodeContext> expanded = new HashSet();
        private final HashMap<NodeContext, PrimitiveQueryUpdater> expandedQueries = new HashMap();
        private NatTable natTable;
        private List<TreeNode> list;
        ILayerListener treeListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                block5: {
                    block4: {
                        if (!(event instanceof ShowRowPositionsEvent)) break block4;
                        ShowRowPositionsEvent e = (ShowRowPositionsEvent)event;
                        for (Range r : e.getRowPositionRanges()) {
                            int expanded = ((TreeNodeIsExpandedProcessor)TreeNodeIsExpandedProcessor.this).NatTableGraphExplorer.this.viewportLayer.getRowIndexByPosition(r.start - 2) + 1;
                            if (expanded < 0 || expanded >= TreeNodeIsExpandedProcessor.this.list.size()) {
                                return;
                            }
                            TreeNodeIsExpandedProcessor.this.nodeStatusChanged(TreeNodeIsExpandedProcessor.this.list.get(expanded).getContext(), true);
                        }
                        break block5;
                    }
                    if (!(event instanceof HideRowPositionsEvent)) break block5;
                    HideRowPositionsEvent e = (HideRowPositionsEvent)event;
                    for (Range r : e.getRowPositionRanges()) {
                        int collapsed = ((TreeNodeIsExpandedProcessor)TreeNodeIsExpandedProcessor.this).NatTableGraphExplorer.this.viewportLayer.getRowIndexByPosition(r.start - 2);
                        if (collapsed < 0 || collapsed >= TreeNodeIsExpandedProcessor.this.list.size()) {
                            return;
                        }
                        TreeNodeIsExpandedProcessor.this.nodeStatusChanged(TreeNodeIsExpandedProcessor.this.list.get(collapsed).getContext(), false);
                    }
                }
            }
        };

        public Object getIdentifier() {
            return BuiltinKeys.IS_EXPANDED;
        }

        public String toString() {
            return "IsExpandedProcessor";
        }

        public Boolean query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Boolean> key) {
            boolean isExpanded = this.expanded.contains(context);
            this.expandedQueries.put(context, updater);
            return isExpanded;
        }

        public Collection<NodeContext> getExpanded() {
            return new HashSet<NodeContext>(this.expanded);
        }

        public boolean getExpanded(NodeContext context) {
            return this.expanded.contains(context);
        }

        public boolean setExpanded(NodeContext context, boolean expanded) {
            return this._setExpanded(context, expanded);
        }

        public boolean replaceExpanded(NodeContext context, boolean expanded) {
            return this.nodeStatusChanged(context, expanded);
        }

        private boolean _setExpanded(NodeContext context, boolean expanded) {
            if (expanded) {
                return this.expanded.add(context);
            }
            return this.expanded.remove(context);
        }

        protected boolean nodeStatusChanged(NodeContext context, boolean expanded) {
            boolean result = this._setExpanded(context, expanded);
            PrimitiveQueryUpdater updater = this.expandedQueries.get(context);
            if (updater != null) {
                updater.scheduleReplace(context, BuiltinKeys.IS_EXPANDED, (Object)expanded);
            }
            return result;
        }

        public void attached(GraphExplorer explorer) {
            Object control = explorer.getControl();
            if (control instanceof NatTable) {
                this.natTable = (NatTable)control;
                this.list = ((NatTableGraphExplorer)explorer).list;
                this.natTable.addLayerListener(this.treeListener);
            } else {
                System.out.println("WARNING: " + ((Object)((Object)this)).getClass().getSimpleName() + " attached to unsupported control: " + control);
            }
        }

        public void clear() {
            this.expanded.clear();
            this.expandedQueries.clear();
        }

        public void detached(GraphExplorer explorer) {
            this.clear();
            if (this.natTable != null) {
                this.natTable.removeLayerListener(this.treeListener);
                this.natTable = null;
            }
        }
    }

    private class UpdateItem {
        TreeNode element;
        int columnIndex;

        public UpdateItem(TreeNode element) {
            this(element, -1);
        }

        public UpdateItem(TreeNode element, int columnIndex) {
            this.element = element;
            this.columnIndex = columnIndex;
            if (element != null && element.isDisposed()) {
                throw new IllegalArgumentException("Node is disposed. " + element);
            }
        }

        public void update(NatTable natTable) {
            if (this.element != null) {
                if (this.element.isDisposed()) {
                    return;
                }
                if (this.element.updateChildren()) {
                    NatTableGraphExplorer.this.listReIndex();
                    if (!this.element.isHidden()) {
                        if (!this.element.isExpanded()) {
                            if (this.element.listIndex >= 0) {
                                NatTableGraphExplorer.this.treeLayer.collapseTreeRow(this.element.listIndex);
                            }
                        } else {
                            for (TreeNode c : this.element.getChildren()) {
                                c.initData();
                            }
                        }
                    } else {
                        TreeNode p = this.element.getCollapsedAncestor();
                        if (p != null) {
                            if (this.element.listIndex >= 0) {
                                NatTableGraphExplorer.this.treeLayer.collapseTreeRow(this.element.listIndex);
                            }
                            if (p.listIndex >= 0) {
                                NatTableGraphExplorer.this.treeLayer.collapseTreeRow(p.listIndex);
                            }
                        }
                    }
                } else {
                    this.element.initData();
                    natTable.redraw();
                }
                if (!(this.element.autoExpanded || this.element.isDisposed() || NatTableGraphExplorer.this.autoExpandLevel <= 1 || this.element.isExpanded() || this.element.getDepth() > NatTableGraphExplorer.this.autoExpandLevel)) {
                    NatTableGraphExplorer.this.expand = true;
                    this.element.autoExpanded = true;
                    this.element.initData();
                    NatTableGraphExplorer.this.treeLayer.expandTreeRow(this.element.getListIndex());
                    NatTableGraphExplorer.this.expand = false;
                }
            } else if (NatTableGraphExplorer.this.rootNode.updateChildren()) {
                NatTableGraphExplorer.this.listReIndex();
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UpdateItem other = (UpdateItem)obj;
            if (this.columnIndex != other.columnIndex) {
                return false;
            }
            if (this.element != null) {
                return this.element.equals(other.element);
            }
            return other.element == null;
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.hashCode() + this.columnIndex;
            }
            return 0;
        }
    }

    static class UpdateRunner
    implements Runnable {
        final NatTableGraphExplorer ge;

        UpdateRunner(NatTableGraphExplorer ge, IGraphExplorerContext geContext) {
            this.ge = ge;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            HashSet<UpdateItem> items;
            if (this.ge.isDisposed()) {
                return;
            }
            ScrollBar verticalBar = this.ge.natTable.getVerticalBar();
            HashSet<UpdateItem> hashSet = this.ge.pendingItems;
            synchronized (hashSet) {
                items = this.ge.pendingItems;
                this.ge.pendingItems = new HashSet();
            }
            for (UpdateItem item : items) {
                item.update(this.ge.natTable);
            }
            boolean currentlyVerticalBarVisible = verticalBar.isVisible();
            if (this.ge.verticalBarVisible != currentlyVerticalBarVisible) {
                this.ge.verticalBarVisible = currentlyVerticalBarVisible;
                this.ge.natTable.getParent().layout();
            }
            HashSet<UpdateItem> hashSet2 = this.ge.pendingItems;
            synchronized (hashSet2) {
                if (!this.ge.scheduleUpdater()) {
                    this.ge.updating = false;
                }
            }
        }
    }
}

