/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.simantics.browsing.ui.nattable.GETreeData;
import org.simantics.browsing.ui.nattable.TreeNode;

public class GEStyler
extends CellPainterWrapper {
    private GETreeData treeData;
    private ConfigRegistryWrapper wrapper = new ConfigRegistryWrapper();

    public GEStyler(GETreeData treeData, ICellPainter painter) {
        super(painter);
        this.treeData = treeData;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        this.wrapper.clear();
        this.wrapper.wrappedRegistry = configRegistry;
        TreeNode node = this.treeData.getDataAtIndex(cell.getRowIndex());
        Style style = new Style();
        node.getStyle(cell.getColumnIndex(), style);
        Image image = node.getImage(cell.getColumnIndex());
        if (image != null) {
            style.setAttributeValue(CellStyleAttributes.IMAGE, (Object)image);
        }
        this.wrapper.setSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "BODY", style);
        this.wrapper.setSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT", "BODY", style);
        this.wrapper.setSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, "SELECT_HOVER", "BODY", style);
        super.paintCell(cell, gc, rectangle, (IConfigRegistry)this.wrapper);
    }

    private class ConfigRegistryWrapper
    extends ConfigRegistry {
        IConfigRegistry wrappedRegistry;
        Map<ConfigAttribute<?>, Map<String, Map<String, ?>>> configRegistry = new HashMap();

        private ConfigRegistryWrapper() {
        }

        public void clear() {
            this.configRegistry.clear();
        }

        public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode, String ... configLabels) {
            return (T)this.wrappedRegistry.getConfigAttribute(configAttribute, targetDisplayMode, configLabels);
        }

        public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, String targetDisplayMode, List<String> configLabels) {
            return (T)this.wrappedRegistry.getConfigAttribute(configAttribute, targetDisplayMode, configLabels);
        }

        public <T> T getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode, String configLabel) {
            T value = this._getSpecificConfigAttribute(configAttribute, displayMode, configLabel);
            if (value != null) {
                return value;
            }
            return (T)this.wrappedRegistry.getSpecificConfigAttribute(configAttribute, displayMode, configLabel);
        }

        public <T> T _getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode, String configLabel) {
            Map<String, ?> configAttributeMap;
            T attributeValue = null;
            Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
            if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get(displayMode)) != null && (attributeValue = (T)configAttributeMap.get(configLabel)) != null) {
                return attributeValue;
            }
            return attributeValue;
        }

        public <T> void setSpecificConfigAttribute(ConfigAttribute<T> configAttribute, String displayMode, String configLabel, T attributeValue) {
            Map<String, ?> configAttributeMap;
            Map<String, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
            if (displayModeConfigAttributeMap == null) {
                displayModeConfigAttributeMap = new HashMap();
                this.configRegistry.put(configAttribute, displayModeConfigAttributeMap);
            }
            if ((configAttributeMap = displayModeConfigAttributeMap.get(displayMode)) == null) {
                configAttributeMap = new HashMap();
                displayModeConfigAttributeMap.put(displayMode, configAttributeMap);
            }
            configAttributeMap.put(configLabel, attributeValue);
        }

        public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue) {
            this.wrappedRegistry.registerConfigAttribute(configAttribute, attributeValue);
        }

        public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, String targetDisplayMode) {
            this.wrappedRegistry.registerConfigAttribute(configAttribute, attributeValue, targetDisplayMode);
        }

        public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, String targetDisplayMode, String configLabel) {
            this.wrappedRegistry.registerConfigAttribute(configAttribute, attributeValue, targetDisplayMode, configLabel);
        }

        public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType) {
            this.wrappedRegistry.unregisterConfigAttribute(configAttributeType);
        }

        public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode) {
            this.wrappedRegistry.unregisterConfigAttribute(configAttributeType, displayMode);
        }

        public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, String displayMode, String configLabel) {
            this.wrappedRegistry.unregisterConfigAttribute(configAttributeType, displayMode, configLabel);
        }

        public IDisplayModeOrdering getDisplayModeOrdering() {
            return this.wrappedRegistry.getDisplayModeOrdering();
        }
    }
}

