package org.simantics.browsing.ui.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModelListener;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;

/**
 * ITreeRowModel that does not automatically expand all child nodes (as TreeRowModel does). 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 * @param <T>
 */
public class GETreeRowModel<T> implements ITreeRowModel<T>{
	//private final HashSet<Integer> parentIndexes = new HashSet<Integer>();
	//private final TIntHashSet parentIndexes = new TIntHashSet(1000, 0.8f);
	private final IntOpenHashSet expandedIndexes = new IntOpenHashSet();

	private final Collection<ITreeRowModelListener> listeners = new HashSet<ITreeRowModelListener>();

	private final ITreeData<T> treeData;

	public GETreeRowModel(ITreeData<T> treeData) {
		this.treeData = treeData;
	}

	public void registerRowGroupModelListener(ITreeRowModelListener listener) {
		this.listeners.add(listener);
	}

	public void notifyListeners() {
		for (ITreeRowModelListener listener : this.listeners) {
			listener.treeRowModelChanged();
		}
	}

	public int depth(int index) {
		return this.treeData.getDepthOfData(this.treeData.getDataAtIndex(index));
	}

	public boolean isLeaf(int index) {
		return !hasChildren(index);
	}

	public String getObjectAtIndexAndDepth(int index, int depth) {
		return this.treeData.formatDataForDepth(depth,this.treeData.getDataAtIndex(index));
	}

	public boolean hasChildren(int index) {
		return this.treeData.hasChildren(this.treeData.getDataAtIndex(index));
	}
	
	public boolean isCollapsed(int index) {
		return !this.expandedIndexes.contains(index);
	}

	public void clear() {
		this.expandedIndexes.clear();
	}
	
	@Override
	public boolean isCollapsible(int index) {
		return hasChildren(index);
	}

	@Override
	public List<Integer> collapse(int index) {
		this.expandedIndexes.remove(index);
		notifyListeners();
		List<Integer> list = getChildIndexes(index);
		//this.parentIndexes.addAll(list);
		return list;
	}
	
	

	@Override
	public List<Integer> expand(int index) {
		this.expandedIndexes.add(index);
		notifyListeners();
		List<Integer> children = getExpandedChildIndexes(index);
		return children;
	}
	
	@Override
	public List<Integer> collapseAll() {
		return null;
	}
	
	
	@Override
	public List<Integer> expandToLevel(int level) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public List<Integer> expandToLevel(T object, int level) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public List<Integer> expandAll() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public List<Integer> expandToLevel(int parentIndex, int level) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public List<T> getChildren(int parentIndex) {
		T t = treeData.getDataAtIndex(parentIndex);
		return treeData.getChildren(t,true);
	}
	
	@Override
	public List<T> getDirectChildren(int parentIndex) {
		return treeData.getChildren(parentIndex);
	}
	
	
	@Override
	public List<Integer> collapse(T object) {
		int index = treeData.indexOf(object);
		return collapse(index);
	}
	
	@Override
	public List<Integer> expand(T object) {
		int index = treeData.indexOf(object);
		return expand(index);
	}
	
	@Override
	public boolean isCollapsed(T object) {
		int index = treeData.indexOf(object);
		return isCollapsed(index);
	}
	

	@SuppressWarnings("unchecked")
	public List<Integer> getChildIndexes(int parentIndex) {
		List<Integer> result = new ArrayList<Integer>();
		T t = this.treeData.getDataAtIndex(parentIndex);
		if (t == null)
			return Collections.EMPTY_LIST;
		List<T> children = this.treeData.getChildren(t);
		for (T child : children) {
			int index = this.treeData.indexOf(child);
			if (index >= 0) {
				result.add(index);
				result.addAll(getChildIndexes(index));
			} else {
				result.addAll(getChildIndexes(child));
			}
		}
		return result;
	}
	
	public List<Integer> getChildIndexes(T t) {
		List<Integer> result = new ArrayList<Integer>();
		List<T> children = this.treeData.getChildren(t);
		for (T child : children) {
			int index = this.treeData.indexOf(child);
			if (index >= 0) {
				result.add(index);
				result.addAll(getChildIndexes(index));
			} else {
				result.addAll(getChildIndexes(child));
			}
		}
		return result;
	}
	
	@SuppressWarnings("unchecked")
	public List<Integer> getExpandedChildIndexes(int parentIndex) {
		List<Integer> result = new ArrayList<Integer>();
		T t = this.treeData.getDataAtIndex(parentIndex);
		if (t == null)
			return Collections.EMPTY_LIST;
		List<T> children = this.treeData.getChildren(t);
		for (T child : children) {
			int index = this.treeData.indexOf(child);
			if (index >= 0) {
				result.add(index);
				if (expandedIndexes.contains(index))
					result.addAll(getExpandedChildIndexes(index));
			} else {
				result.addAll(getExpandedChildIndexes(child));
			}
		}
		return result;
	}
	
	public List<Integer> getExpandedChildIndexes(T t) {
		List<Integer> result = new ArrayList<Integer>();
		List<T> children = this.treeData.getChildren(t);
		for (T child : children) {
			int index = this.treeData.indexOf(child);
			if (index >= 0) {
				result.add(index);
				if (expandedIndexes.contains(index))
					result.addAll(getExpandedChildIndexes(index));
			} else {
				result.addAll(getExpandedChildIndexes(child));
			}
		}
		return result;
	}
	
	@Override
	public List<Integer> getDirectChildIndexes(int parentIndex) {
		List<Integer> result = new ArrayList<Integer>();
		T t = this.treeData.getDataAtIndex(parentIndex);
		if (t == null)
			return Collections.EMPTY_LIST;
		List<T> children = this.treeData.getChildren(t);
		for (T child : children) {
			int index = this.treeData.indexOf(child);
			if (index >= 0) {
				result.add(index);
			}
		}
		return result;
	}
	
	public ITreeData<T> getTreeData() {
		return treeData;
	}
}
