/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.visuals;

import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.check.CheckedStateContribution;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationContribution;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationRule;
import org.simantics.browsing.ui.model.images.ImageContribution;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationContribution;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.browsing.ui.model.labels.LabelContribution;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.browsing.ui.model.modifiers.ModifierContribution;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.OrderedNodeTypeMultiMap;
import org.simantics.browsing.ui.model.sorters.SorterContribution;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.tooltips.TooltipContribution;
import org.simantics.browsing.ui.model.tooltips.TooltipRule;
import org.simantics.browsing.ui.model.visuals.FlatNodeContribution;
import org.simantics.browsing.ui.model.visuals.VisualsRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class VisualsContribution
implements Comparable<VisualsContribution> {
    protected NodeType nodeType;
    protected Test test;
    protected double priority;

    public VisualsContribution(NodeType nodeType, Test test, double priority) throws InvalidContribution {
        if (test != null && !test.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Test is not compatible with the content type.");
        }
        this.nodeType = nodeType;
        this.test = test;
        this.priority = priority;
    }

    public static void load(ReadGraph g, Resource visualsContributionResource, OrderedNodeTypeMultiMap<LabelContribution> labelContributions, OrderedNodeTypeMultiMap<ImageContribution> imageContributions, OrderedNodeTypeMultiMap<CheckedStateContribution> checkedStateContributions, OrderedNodeTypeMultiMap<LabelDecorationContribution> labelDecorationContributions, OrderedNodeTypeMultiMap<ImageDecorationContribution> imageDecorationContributions, OrderedNodeTypeMultiMap<ModifierContribution> modifierContributions, OrderedNodeTypeMultiMap<SorterContribution> sorterContributions, OrderedNodeTypeMultiMap<FlatNodeContribution> flatNodeContributions, OrderedNodeTypeMultiMap<TooltipContribution> tooltipContributions) throws DatabaseException, InvalidContribution {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        Resource testResource = g.getPossibleObject(visualsContributionResource, vr.VisualsContribution_HasCondition);
        Test test = testResource == null ? null : (Test)g.adapt(testResource, Test.class);
        Double mpriority = (Double)g.getPossibleRelatedValue(visualsContributionResource, vr.VisualsContribution_HasPriority);
        double priority = mpriority == null ? 0.0 : mpriority;
        for (Resource nodeTypeResource : g.getObjects(visualsContributionResource, vr.VisualsContribution_HasNodeType)) {
            NodeType nodeType = (NodeType)g.adapt(nodeTypeResource, NodeType.class);
            for (Resource ruleResource : g.getObjects(visualsContributionResource, vr.VisualsContribution_HasRule)) {
                VisualsRule rule;
                if (ruleResource.equals(vr.FlatNodeRule)) {
                    flatNodeContributions.put(nodeType, (Object)FlatNodeContribution.INSTANCE);
                    continue;
                }
                try {
                    rule = (VisualsRule)g.adapt(ruleResource, VisualsRule.class);
                }
                catch (AdaptionException e) {
                    e.printStackTrace();
                    continue;
                }
                try {
                    if (rule instanceof LabelRule) {
                        labelContributions.put(nodeType, new LabelContribution(nodeType, test, (LabelRule)rule, priority));
                    }
                    if (rule instanceof ModifierRule) {
                        modifierContributions.put(nodeType, new ModifierContribution(nodeType, test, (ModifierRule)rule, priority));
                    }
                    if (rule instanceof ImageRule) {
                        imageContributions.put(nodeType, new ImageContribution(nodeType, test, (ImageRule)rule, priority));
                    }
                    if (rule instanceof CheckedStateRule) {
                        checkedStateContributions.put(nodeType, new CheckedStateContribution(nodeType, test, (CheckedStateRule)rule, priority));
                    }
                    if (rule instanceof LabelDecorationRule) {
                        labelDecorationContributions.put(nodeType, new LabelDecorationContribution(nodeType, test, (LabelDecorationRule)rule, priority));
                    }
                    if (rule instanceof ImageDecorationRule) {
                        imageDecorationContributions.put(nodeType, new ImageDecorationContribution(nodeType, test, (ImageDecorationRule)rule, priority));
                    }
                    if (rule instanceof SorterRule) {
                        sorterContributions.put(nodeType, new SorterContribution(nodeType, test, (SorterRule)rule, priority));
                    }
                    if (!(rule instanceof TooltipRule)) continue;
                    tooltipContributions.put(nodeType, new TooltipContribution(nodeType, test, (TooltipRule)rule, priority));
                }
                catch (InvalidContribution e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public int compareTo(VisualsContribution o) {
        return Double.compare(o.priority, this.priority);
    }
}

