/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.tooltips;

import java.util.HashMap;
import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.tooltips.TooltipRule;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class TooltipContribution
extends VisualsContribution {
    TooltipRule tooltipRule;
    private Map<Object, Object> auxiliary = new HashMap<Object, Object>();

    public TooltipContribution(NodeType nodeType, Test test, TooltipRule tooltipRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!tooltipRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Tooltip rule is not compatible with the content type.");
        }
        this.tooltipRule = tooltipRule;
    }

    public Object getTooltip(Object event, Object parent, NodeContext context) {
        try {
            Object object = this.tooltipRule.createTooltip(event, parent, context, this.auxiliary);
            return object;
        }
        finally {
            this.auxiliary.clear();
        }
    }

    public boolean shouldCreateToolTip(ReadGraph graph, NodeContext context) throws DatabaseException {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        if (this.test != null && !this.test.test(graph, content)) {
            return false;
        }
        return this.tooltipRule.shouldCreateToolTip(graph, context, this.auxiliary);
    }
}

