/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.queries;

import java.util.Collections;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.ActionBrowseContextRequest;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.project.ontology.ProjectResource;

public class IsNodeContextRemovable
extends UnaryRead<NodeContext, Boolean> {
    public IsNodeContextRemovable(NodeContext context) {
        super((Object)context);
    }

    public Boolean perform(ReadGraph graph) throws DatabaseException {
        Remover remover;
        boolean result = false;
        try {
            ActionBrowseContext defaultContext = (ActionBrowseContext)graph.syncRequest((Read)new ActionBrowseContextRequest(Collections.singleton(ProjectResource.getInstance((ReadGraph)graph).ProjectActionContext)), (AsyncProcedure)TransientCacheAsyncListener.instance());
            ActionBrowseContext browseContext = ActionBrowseContext.get(graph, (NodeContext)this.parameter, defaultContext);
            if (browseContext != null && !browseContext.canRemove(graph, (NodeContext)this.parameter)) {
                return false;
            }
            result = true;
        }
        catch (DatabaseException databaseException) {
            return false;
        }
        Object input = ((NodeContext)this.parameter).getConstant(BuiltinKeys.INPUT);
        if (result && input instanceof Resource && (remover = (Remover)graph.syncRequest(Queries.adapt((Resource)((Resource)input), Remover.class, (boolean)true))) != null) {
            if (remover.canRemove(graph, null) == null) {
                return true;
            }
            return false;
        }
        return result;
    }
}

