/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.nodetypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.selection.WorkbenchSelectionElement;

public class EntityNodeType
implements NodeType {
    public List<Resource> entityTypes;
    private static final WeakHashMap<List<Resource>, EntityNodeType> nodeTypeCache = new WeakHashMap();

    private EntityNodeType(List<Resource> entityTypes) {
        this.entityTypes = entityTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityNodeType create(Resource entityType) {
        List<Resource> entityTypes = Collections.singletonList(entityType);
        WeakHashMap<List<Resource>, EntityNodeType> weakHashMap = nodeTypeCache;
        synchronized (weakHashMap) {
            EntityNodeType result = nodeTypeCache.get(entityTypes);
            if (result == null) {
                result = new EntityNodeType(entityTypes);
                nodeTypeCache.put(entityTypes, result);
            }
            return result;
        }
    }

    public static EntityNodeType create(Collection<Resource> entityTypes) {
        return EntityNodeType.createInternal(new ArrayList<Resource>(entityTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EntityNodeType createInternal(ArrayList<Resource> entityTypes) {
        if (entityTypes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (entityTypes.size() == 1) {
            return EntityNodeType.create(entityTypes.get(0));
        }
        Collections.sort(entityTypes);
        WeakHashMap<List<Resource>, EntityNodeType> weakHashMap = nodeTypeCache;
        synchronized (weakHashMap) {
            EntityNodeType result = nodeTypeCache.get(entityTypes);
            if (result == null) {
                result = new EntityNodeType(entityTypes);
                nodeTypeCache.put(entityTypes, result);
            }
            return result;
        }
    }

    public static NodeType getNodeTypeFor(ReadGraph graph, Resource resource) throws DatabaseException {
        ArrayList<Resource> types = new ArrayList<Resource>(graph.getPrincipalTypes(resource));
        if (types.isEmpty()) {
            return null;
        }
        return EntityNodeType.createInternal(types);
    }

    public NodeType getNodeTypeOf(ReadGraph graph, Resource resource) throws DatabaseException {
        ArrayList<Resource> types = new ArrayList<Resource>();
        block0: for (Resource t : graph.getPrincipalTypes(resource)) {
            for (Resource et : this.entityTypes) {
                if (!graph.isInheritedFrom(t, et)) continue block0;
            }
            types.add(t);
        }
        if (types.isEmpty()) {
            return null;
        }
        return EntityNodeType.createInternal(types);
    }

    @Override
    public NodeContext createNodeContext(ReadGraph graph, Object content) throws DatabaseException {
        Resource resource;
        NodeType nodeType;
        if (content instanceof Resource && (nodeType = this.getNodeTypeOf(graph, resource = (Resource)content)) != null) {
            return NodeContextBuilder.buildWithData((NodeContext.ConstantKey[])KEY_SEQUENCE, (Object[])new Object[]{content, nodeType});
        }
        return null;
    }

    @Override
    public Class<?> getContentType() {
        return Resource.class;
    }

    public int hashCode() {
        return this.entityTypes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityNodeType other = (EntityNodeType)obj;
        return this.entityTypes.equals(other.entityTypes);
    }

    @Override
    public boolean inherits(ReadGraph graph, NodeType superType) throws DatabaseException {
        if (this == superType) {
            return true;
        }
        if (superType.getClass() != EntityNodeType.class) {
            return false;
        }
        block0: for (Resource st : ((EntityNodeType)superType).entityTypes) {
            for (Resource t : this.entityTypes) {
                if (graph.isInheritedFrom(t, st)) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public Collection<NodeType> getSuper(ReadGraph g) throws DatabaseException {
        if (this.entityTypes.size() == 1) {
            Layer0 l0 = Layer0.getInstance((ReadGraph)g);
            Collection supertypes = g.getObjects(this.entityTypes.get(0), l0.Inherits);
            ArrayList<NodeType> supernodetypes = new ArrayList<NodeType>(supertypes.size());
            for (Resource supertype : supertypes) {
                supernodetypes.add(EntityNodeType.create(supertype));
            }
            return supernodetypes;
        }
        ArrayList<NodeType> supernodetypes = new ArrayList<NodeType>(this.entityTypes.size());
        for (Resource t : this.entityTypes) {
            supernodetypes.add(EntityNodeType.create(t));
        }
        return supernodetypes;
    }

    @Override
    public String toString(ReadGraph graph) throws DatabaseException {
        StringBuilder b = new StringBuilder();
        b.append('[');
        boolean first = true;
        for (Resource t : this.entityTypes) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)t));
        }
        b.append(']');
        return b.toString();
    }

    @Override
    public WorkbenchSelectionElement getWorkbenchSelectionElement(NodeContext context) {
        return null;
    }
}

