/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;

public class L0StringModifier
implements Labeler.Modifier {
    private final RequestProcessor processor;
    private final Resource subject;
    private final Resource propertyRelation;
    private final Resource literal;

    public L0StringModifier(RequestProcessor processor, Resource subject, Resource propertyRelation, Resource literal) {
        this.processor = processor;
        this.subject = subject;
        this.propertyRelation = propertyRelation;
        this.literal = literal;
    }

    public String getValue() {
        try {
            return (String)this.processor.syncRequest((Read)new PossibleAdapter(this.literal, String.class));
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public String isValid(final String label) {
        try {
            return (String)this.processor.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    StringModifier modifier = (StringModifier)graph.adapt(L0StringModifier.this.literal, StringModifier.class);
                    return modifier.isValid((Object)label);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return e.getMessage();
        }
    }

    public void modify(final String label) {
        try {
            this.processor.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Modify string");
                    graph.markUndoPoint();
                    Statement stm = graph.getPossibleStatement(L0StringModifier.this.subject, L0StringModifier.this.propertyRelation);
                    if (stm.isAsserted(L0StringModifier.this.subject)) {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Resource newLiteral = graph.newResource();
                        for (Resource iof : graph.getObjects(L0StringModifier.this.literal, L0.InstanceOf)) {
                            graph.claim(newLiteral, L0.InstanceOf, null, iof);
                        }
                        graph.claim(L0StringModifier.this.subject, L0StringModifier.this.propertyRelation, newLiteral);
                        StringModifier modifier = (StringModifier)graph.adapt(newLiteral, StringModifier.class);
                        modifier.modify(graph, (Object)label);
                    } else {
                        StringModifier modifier = (StringModifier)graph.adapt(L0StringModifier.this.literal, StringModifier.class);
                        modifier.modify(graph, (Object)label);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }
}

