/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;

public class CompositeChildRule
implements ChildRule {
    List<ChildRule> childRules;

    public CompositeChildRule(List<ChildRule> childRules) {
        this.childRules = childRules;
    }

    public CompositeChildRule(ReadGraph graph, Resource orderedSet) throws DatabaseException {
        List childRuleResources = OrderedSetUtils.toList((ReadGraph)graph, (Resource)orderedSet);
        this.childRules = new ArrayList<ChildRule>(childRuleResources.size());
        for (Resource childRuleResource : childRuleResources) {
            this.childRules.add((ChildRule)graph.adapt(childRuleResource, ChildRule.class));
        }
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        Collection<Object> result = Collections.singleton(parent);
        int i = 0;
        while (i < this.childRules.size()) {
            ChildRule rule = this.childRules.get(i);
            ArrayList children = new ArrayList();
            for (Object e : result) {
                children.addAll(rule.getChildren(graph, e));
            }
            result = children;
            ++i;
        }
        return result;
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        Collection<Object> result = Collections.singleton(child);
        int i = this.childRules.size() - 1;
        while (i >= 0) {
            ChildRule rule = this.childRules.get(i);
            ArrayList parents = new ArrayList();
            for (Object e : result) {
                parents.addAll(rule.getParents(graph, e));
            }
            result = parents;
            --i;
        }
        return result;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        if (this.childRules.isEmpty()) {
            return true;
        }
        return this.childRules.get(0).isCompatible(contentType);
    }
}

