/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ChildContribution {
    double priority;
    String identifier;
    NodeType parentNodeType;
    NodeType childNodeType;
    ChildRule childRule;

    public ChildContribution(String identifier, double priority, NodeType parentNodeType, NodeType childNodeType, ChildRule childRule) throws InvalidContribution {
        if (!childRule.isCompatible(parentNodeType.getContentType())) {
            throw new InvalidContribution("Child rule is not compatible with the parent content type.");
        }
        this.parentNodeType = parentNodeType;
        this.childNodeType = childNodeType;
        this.childRule = childRule;
        this.identifier = identifier;
        this.priority = priority;
    }

    public static ChildContribution createCached(final ReadGraph g, Resource childContributionResource) throws DatabaseException, InvalidContribution {
        try {
            return (ChildContribution)g.syncRequest((Read)new ResourceRead<ChildContribution>(childContributionResource){

                public ChildContribution perform(ReadGraph graph) throws DatabaseException {
                    try {
                        return ChildContribution.create(g, this.resource);
                    }
                    catch (InvalidContribution e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            }, (AsyncProcedure)TransientCacheAsyncListener.instance());
        }
        catch (DatabaseException e) {
            Throwable c = e.getCause();
            if (c instanceof InvalidContribution) {
                throw (InvalidContribution)c;
            }
            throw e;
        }
    }

    public static ChildContribution create(ReadGraph g, Resource childContributionResource) throws DatabaseException, InvalidContribution {
        Double priority;
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        Resource parentNodeTypeResource = g.getSingleObject(childContributionResource, vr.ChildContribution_HasParentNodeType);
        NodeType parentNodeType = (NodeType)g.adapt(parentNodeTypeResource, NodeType.class);
        Resource childNodeTypeResource = g.getSingleObject(childContributionResource, vr.ChildContribution_HasChildNodeType);
        NodeType childNodeType = (NodeType)g.adapt(childNodeTypeResource, NodeType.class);
        Resource childRuleResource = g.getSingleObject(childContributionResource, vr.ChildContribution_HasRule);
        ChildRule childRule = (ChildRule)g.adapt(childRuleResource, ChildRule.class);
        String identifier = (String)g.getPossibleRelatedValue(childContributionResource, vr.ChildContribution_identifier, (Binding)Bindings.STRING);
        if (identifier == null) {
            identifier = "";
        }
        if ("".equals(identifier) && (identifier = g.getPossibleURI(childContributionResource)) == null) {
            identifier = NameUtils.getSafeName((ReadGraph)g, (Resource)childContributionResource, (boolean)true);
        }
        if ((priority = (Double)g.getPossibleRelatedValue(childContributionResource, vr.ChildContribution_priority, (Binding)Bindings.DOUBLE)) == null) {
            priority = 0.0;
        }
        return new ChildContribution(identifier, priority, parentNodeType, childNodeType, childRule);
    }

    public NodeType getParentNodeType() {
        return this.parentNodeType;
    }

    public NodeType getChildNodeType() {
        return this.childNodeType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public double getPriority() {
        return this.priority;
    }

    public Collection<NodeContext> getChildren(ReadGraph graph, NodeContext parent) {
        try {
            Object parentContent = parent.getConstant(BuiltinKeys.INPUT);
            Collection<?> childContents = this.childRule.getChildren(graph, parentContent);
            if (childContents.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<NodeContext> children = new ArrayList<NodeContext>(childContents.size());
            for (Object childContent : childContents) {
                NodeContext child = this.childNodeType.createNodeContext(graph, childContent);
                if (child == null) continue;
                children.add(child);
            }
            return children;
        }
        catch (PendingVariableException pendingVariableException) {
            return Collections.emptyList();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public Collection<NodeContext> getParents(ReadGraph graph, NodeContext child) {
        try {
            Object childContent = child.getConstant(BuiltinKeys.INPUT);
            Collection<?> parentContents = this.childRule.getParents(graph, childContent);
            if (parentContents.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<NodeContext> parents = new ArrayList<NodeContext>(parentContents.size());
            for (Object parentContent : parentContents) {
                NodeContext parent = this.parentNodeType.createNodeContext(graph, parentContent);
                if (parent == null) continue;
                parents.add(parent);
            }
            return parents;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(ReadGraph graph, NodeContext parent) {
        try {
            Object childContent;
            NodeContext child;
            Object parentContent = parent.getConstant(BuiltinKeys.INPUT);
            Collection<?> childContents = this.childRule.getChildren(graph, parentContent);
            if (childContents.isEmpty()) {
                return false;
            }
            Iterator<?> iterator = childContents.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((child = this.childNodeType.createNodeContext(graph, childContent = iterator.next())) == null);
            return true;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String toString() {
        return this.identifier;
    }
}

