/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.actions;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeTypeMultiMap;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class TestContribution
implements Comparable<TestContribution> {
    NodeType nodeType;
    Test test;
    double priority;

    public TestContribution(NodeType nodeType, Test test, double priority) {
        this.nodeType = nodeType;
        this.test = test;
        this.priority = priority;
    }

    public static void load(ReadGraph g, Resource r, NodeTypeMultiMap<TestContribution> contributions) throws DatabaseException {
        ViewpointResource VR = ViewpointResource.getInstance((ReadGraph)g);
        NodeType nodeType = (NodeType)g.adapt(g.getSingleObject(r, VR.TestContribution_HasNodeType), NodeType.class);
        Resource testResource = g.getPossibleObject(r, VR.TestContribution_HasTest);
        Test test = testResource == null ? null : (Test)g.adapt(testResource, Test.class);
        Double mpriority = (Double)g.getPossibleRelatedValue(r, VR.DropActionContribution_HasPriority);
        double priority = mpriority == null ? 0.0 : mpriority;
        contributions.put(nodeType, new TestContribution(nodeType, test, priority));
    }

    public boolean test(ReadGraph graph, NodeContext context) {
        try {
            return this.test == null || this.test.test(graph, context.getConstant(BuiltinKeys.INPUT));
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return false;
        }
    }

    @Override
    public int compareTo(TestContribution o) {
        return Double.compare(o.priority, this.priority);
    }
}

