package org.simantics.browsing.ui.model.tooltips;

import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;

public class DescriptionTooltipRule implements TooltipRule {

    public static final DescriptionTooltipRule INSTANCE = new DescriptionTooltipRule();

    public DescriptionTooltipRule() {
    }

    @Override
    public Object createTooltip(Object event, Object parentComponent, NodeContext context, Map<Object, Object> auxiliary) {
        Composite parent = (Composite)parentComponent;
        Composite composite = new Composite(parent, SWT.NONE);
        //ScrolledComposite composite = new ScrolledComposite(parent, SWT.NONE);
        
        composite.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_INFO_BACKGROUND));
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout(layout);
        Text text = new Text(composite, SWT.NONE | SWT.READ_ONLY | SWT.WRAP);
        text.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_INFO_BACKGROUND));
        
        String toolTipContent = (String) auxiliary.get("content");
        text.setText(toolTipContent);
        
        GC gc = new GC(text);
        FontMetrics fm = gc.getFontMetrics();
        int width = toolTipContent.length() * fm.getAverageCharWidth();
        gc.dispose();
        GridData gridData = new GridData();
        if (width < 500)
            gridData.widthHint = width;
        else
            gridData.widthHint = 500;
        
        text.setLayoutData(gridData);
        
        return composite;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return (contentType == Resource.class || contentType == Variable.class);
    }

    private static String getToolTipContent(ReadGraph graph, NodeContext nodeContext) throws DatabaseException {
        Object input = nodeContext.getConstant(BuiltinKeys.INPUT);
        if (input instanceof Variable) {
            Variable var = (Variable) input;
            Resource res = var.getPossiblePredicateResource(graph);
            if (res != null) {
                Layer0 L0 = Layer0.getInstance(graph);
                return graph.getPossibleRelatedValue2(res, L0.HasDescription);
            }
        } else if (input instanceof Resource) {
            Resource res = (Resource) input;
            Layer0 L0 = Layer0.getInstance(graph);
            return graph.getPossibleRelatedValue2(res, L0.HasDescription);
        }
        return null;
    }

    @Override
    public boolean shouldCreateToolTip(ReadGraph graph, NodeContext context, Map<Object, Object> auxiliary) throws DatabaseException {
        String content = getToolTipContent(graph, context);
        if (content == null || content.isEmpty())
            return false;
        auxiliary.put("content", content);
        return true;
    }

}
