/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.tester;

import java.util.Set;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.graph.impl.CommonKeys;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.Container;

public class StandardContextHasSomeTypeTester implements Tester {

    private Resource[] test;

    public StandardContextHasSomeTypeTester(Resource... types) {
        this.test = types;
    }

    public StandardContextHasSomeTypeTester(RequestProcessor processor, final String... uris) throws DatabaseException {
        processor.syncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                test = new Resource[uris.length];
                for (int i = 0; i < uris.length; i++) {
                    test[i] = graph.getResource(uris[i]);
                }
            }
        });
    }

    @Override
    public boolean test(NodeQueryManager manager, NodeContext context) {
        Container<Set<Resource>> types = manager.query(context, CommonKeys.STANDARD_CONTEXT_TYPES);
        for (Resource r : test) {
            if (types.get().contains(r)) {
                return true;
            }
        }
        return false;
    }

}
