/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.tester;

import org.simantics.Simantics;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.Testers;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * A facade class for constructing new {@link Tester} instances for standard
 * graph based testing activities. Please use this class instead of directly
 * referring to <code>org.simantics.browsing.ui.graph.tester</code> package
 * classes.
 * 
 * @author Tuukka Lehtonen
 */
public final class GraphTesters {

    public static Tester pass() {
        return Testers.PASS;
    }

    public static Tester fail() {
        return Testers.FAIL;
    }

    /**
     * @param clazz
     * @return
     * 
     * TODO: throw exceptions, don't catch.
     */
    public static Tester type(final String uri) {
        try {
            return type(Simantics.getSession(), uri);
        } catch (DatabaseException e) {
            e.printStackTrace();
            return fail();
        }
    }

    public static Tester standardContextType(final String uri) {
        try {
            return standardContextType(Simantics.getSession(), uri);
        } catch (DatabaseException e) {
            e.printStackTrace();
            return fail();
        }
    }

    public static Tester standardContextType(Session s, final String uri) throws DatabaseException {
        return new StandardContextHasSomeTypeTester(s, uri);
    }

    public static Tester type(Session s, final String uri) throws DatabaseException {
        return new HasSomeTypeTester(s, uri);
    }

    public static Tester type(Resource resource) {
        return new HasSomeTypeTester(resource);
    }

    /**
     * @param uri
     * @return
     * 
     * TODO: throw exceptions, don't catch.
     */
    public static Tester resource(final String uri) {
        try {
            return resource(Simantics.getSession(), uri);
        } catch (DatabaseException e) {
            e.printStackTrace();
            return fail();
        }
    }

    public static Tester resource(Session s, final String uri) throws DatabaseException {
        return new EqualsResourceTester(s, uri);
    }

    public static Tester resource(Resource resource) {
        return new EqualsResourceTester(resource);
    }

    public static Tester inherits(Resource resource) {
        return new InheritsSomeTypeTester(resource);
    }

    public static Tester model() throws DatabaseException {
        Session s = Simantics.getSession();
        SimulationResource SIMU = SimulationResource.getInstance(s);
        return new HasSomeTypeTester(SIMU.Model);
    }

    public static Tester type() {
        return new HasSomeTypeTester(Simantics.getSession().getService(Layer0.class).Type);
    }

    public static Tester orderedSet() {
        return new OrderedSetTester(Simantics.getSession());
    }

    public static Tester orderedSet(Session s) {
        return new OrderedSetTester(s);
    }

    public static Tester hasRelatedObjects(Resource relation) {
        return new HasRelatedObjectsTester(relation);
    }

    public static Tester hasRelatedObjects(RequestProcessor processor, String relationUri) throws DatabaseException {
        return new HasRelatedObjectsTester(processor, relationUri);
    }

    public static Tester hasRelatedObjects(String relationUri) {
        try {
            return hasRelatedObjects(Simantics.getSession(), relationUri);
        } catch (DatabaseException e) {
            e.printStackTrace();
            return fail();
        }
    }

}
