/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.contributor.layer0;

import java.util.Collection;

import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.browsing.ui.graph.tester.GraphTesters;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.simulation.ontology.SimulationResource;

public class ProjectModels extends ViewpointContributor<Resource> {

    @Override
    public Collection<?> getContribution(ReadGraph graph, Resource project) throws DatabaseException {

        return graph.syncRequest(new ObjectsWithType(project, L0.ConsistsOf, SimulationResource.getInstance(graph).Model));

    }

    @Override
    public Tester getNodeContextTester() {
        return GraphTesters.type(ProjectResource.URIs.Project);
    }

    @Override
    public String getViewpointId() {
        return "Standard";
    }

}