/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.viewpoints.ViewpointStub;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

public abstract class LazyViewpoint
extends ViewpointStub {
    private static final Object CHILDREN = new Object();
    private final ResourceQuery<NodeContext[]> childQuery;
    protected final PrimitiveQueryUpdater updater;
    protected final NodeContext context;
    protected final BuiltinKeys.ViewpointKey key;

    public abstract NodeContext[] children(ReadGraph var1) throws DatabaseException;

    public abstract Boolean hasChildren(ReadGraph var1) throws DatabaseException;

    public Object getIdentity() {
        return this.key;
    }

    public LazyViewpoint(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key) {
        assert (updater != null);
        assert (context != null);
        assert (key != null);
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.childQuery = new ResourceQuery<NodeContext[]>((Object)Pair.make((Object)this.getIdentity(), (Object)CHILDREN), context){

            public NodeContext[] perform(ReadGraph graph) throws DatabaseException {
                return LazyViewpoint.this.children(graph);
            }

            public String toString() {
                return String.valueOf(((Object)((Object)LazyViewpoint.this)).toString()) + "[CHILDREN]";
            }
        };
    }

    private Listener<NodeContext[]> createListener() {
        return new Listener<NodeContext[]>(){
            boolean executed = false;
            boolean disposed = false;

            public void execute(NodeContext[] result) {
                LazyViewpoint.this.replaceChildrenResult(result);
                this.executed = true;
            }

            public boolean isDisposed() {
                if (this.disposed) {
                    return true;
                }
                if ((LazyViewpoint.this.updater.isDisposed() || !LazyViewpoint.this.updater.isShown(LazyViewpoint.this.context)) && this.executed) {
                    LazyViewpoint.this.children = Viewpoint.PENDING_CHILDREN;
                    this.disposed = true;
                    return true;
                }
                return false;
            }

            public void exception(Throwable t) {
                System.out.print("LazyViewpoint.childQuery failed: ");
                t.printStackTrace();
            }

            public String toString() {
                return "LazyViewpoint[" + System.identityHashCode((Object)LazyViewpoint.this) + "].childProcedure";
            }
        };
    }

    public NodeContext getContext() {
        return this.context;
    }

    public NodeContext[] getChildren() {
        if (this.children == Viewpoint.PENDING_CHILDREN) {
            DataSource source = this.updater.getDataSource(AsyncReadGraph.class);
            Listener<NodeContext[]> childProcedure = this.createListener();
            source.schedule(graph -> graph.asyncRequest(this.childQuery, childProcedure));
        }
        return this.children;
    }

    public Boolean getHasChildren() {
        if (this.getChildren().length > 0) {
            return true;
        }
        return false;
    }

    protected void replaceChildrenResult(NodeContext[] result) {
        this.setChildren(this.updater, result);
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    protected <T> T getInput(Class<T> clazz) throws ClassCastException {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return (T)o;
    }

    protected <T> T tryGetInput(Class<T> clazz) {
        Object o = this.context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return (T)o;
        }
        return null;
    }
}

