/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.graph.impl.GraphEnumerationModifierBase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;

public class GraphEnumerationModifier
extends GraphEnumerationModifierBase<Resource> {
    protected final Resource subject;
    protected final Resource relation;

    public GraphEnumerationModifier(Session session, Resource subject, Resource relation, Enumeration<Resource> enumeration, Resource value) {
        this(session, subject, relation, enumeration, (EnumeratedValue<Resource>)enumeration.find((Object)value));
    }

    public GraphEnumerationModifier(Session session, Resource subject, Resource relation, Enumeration<Resource> enumeration, EnumeratedValue<Resource> value) {
        super(session, enumeration, value);
        if (subject == null) {
            throw new NullPointerException("null subject");
        }
        if (relation == null) {
            throw new NullPointerException("null relation");
        }
        this.subject = subject;
        this.relation = relation;
    }

    @Override
    protected void modifyWithObject(WriteGraph graph, Resource oldEnumObject, Resource enumObject) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (l0.True.equals(enumObject) || l0.False.equals(enumObject)) {
            Boolean value = l0.True.equals(enumObject);
            Collection props = graph.getObjects(this.subject, this.relation);
            if (props.size() > 1) {
                throw new ValidationException("Multiple (" + props.size() + ") '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.relation) + "' properties found for resource '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.subject) + "'. Expected functional property.");
            }
            graph.claimLiteral(this.subject, this.relation, (Object)value, (Binding)Bindings.BOOLEAN);
        } else {
            if (oldEnumObject != null) {
                graph.deny(this.subject, this.relation);
            }
            if (enumObject != null) {
                graph.claim(this.subject, this.relation, null, enumObject);
            }
        }
    }
}

