/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.StringModifierFactory;
import org.simantics.db.request.Read;

public abstract class AbstractFactoryStringModifier
implements Labeler.Modifier {
    protected Session session;
    protected Resource subject;
    protected Resource predicate;
    protected Resource object;
    protected String initialValue;
    protected StringModifierFactory modifierFactory;
    protected StringModifier modifier;
    protected Throwable modifierFailed;

    public AbstractFactoryStringModifier(Resource subject, Resource predicate, Resource object, RequestProcessor processor) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.session = processor.getSession();
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) throws DatabaseException {
                    AbstractFactoryStringModifier.this.initialValue = AbstractFactoryStringModifier.this.getInitialValue(g);
                    AbstractFactoryStringModifier.this.initializeModifier(g);
                }
            });
        }
        catch (DatabaseException e) {
            this.modifierFailed = e;
        }
    }

    protected void initializeModifier(ReadGraph graph) throws DatabaseException {
        this.modifierFactory = (StringModifierFactory)graph.getPossibleAdapter(this.subject, StringModifierFactory.class);
        if (this.modifierFactory != null) {
            this.modifier = this.modifierFactory.createModifier(graph, this.predicate, this.object);
        }
        if (this.modifier == null) {
            this.modifierFactory = null;
            this.modifier = (StringModifier)graph.adapt(this.object, StringModifier.class);
        }
    }

    protected String getInitialValue(ReadGraph g) throws DatabaseException {
        return (String)g.adapt(this.object, String.class);
    }

    protected StringModifier getModifier() {
        return this.modifier;
    }

    protected StringModifierFactory getModifierFactory() {
        return this.modifierFactory;
    }

    public String getValue() {
        return this.initialValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return this.modifierFailed.getMessage();
        }
        if (this.modifier == null) {
            return "No modifier available";
        }
        String t = this.createModifierInput(label);
        return this.modifier.isValid((Object)t);
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            return;
        }
        String t = this.createModifierInput(label);
        if (!this.verifyModification(t)) {
            return;
        }
        this.doModify(t);
    }

    protected boolean verifyModification(String label) {
        return true;
    }

    public abstract void doModify(String var1);

    public String createModifierInput(String label) {
        return label;
    }
}

