/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.request;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.request.Read;

/**
 * A database query which identifies itself by two fields: an abstract
 * idenfitier and a NodeContext.
 * 
 * @author Antti Villberg
 * 
 * @param <T>
 */
public abstract class ResourceQuery<T> implements Read<T> {

    protected final Object       queryIdentifier;
    protected final NodeContext  context;
    protected int                hash;

    public ResourceQuery(Object queryIdentifier, NodeContext context) {
        assert queryIdentifier != null;
        assert context != null;
        this.queryIdentifier = queryIdentifier;
        this.context = context;
        this.hash = makeHash();
    }

    @Override
    public boolean equals(Object object) {

        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof ResourceQuery<?>))
            return false;

        ResourceQuery<?> query = (ResourceQuery<?>) object;
        return getClass() == query.getClass() && queryIdentifier.equals(query.queryIdentifier) && context.equals(query.context);

    }

    protected int makeHash() {
        return getClass().hashCode() * 31 + context.hashCode() * 41 + queryIdentifier.hashCode();
    }

    @Override
    final public int hashCode() {
        return hash;
    }

}
