/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.request;

import java.util.Arrays;

import org.simantics.browsing.ui.NodeContext;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T>
 */
public abstract class ParametrizedResourceQuery<T> extends ResourceQuery<T> {

    Object[] parameters;

    public ParametrizedResourceQuery(Object queryIdentifier, NodeContext context, Object... parameters) {
        super(queryIdentifier, context);
        this.parameters = parameters;
        this.hash = makeHash();
    }

    @Override
    public boolean equals(Object object) {

        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof ParametrizedResourceQuery<?>))
            return false;

        ParametrizedResourceQuery<?> query = (ParametrizedResourceQuery<?>) object;
        return queryIdentifier.equals(query.queryIdentifier)
        && context.equals(query.context)
        && Arrays.equals(parameters, query.parameters);
    }

    @Override
    protected int makeHash() {
        return (context.hashCode() * 31 + queryIdentifier.hashCode()) * 31 + Arrays.hashCode(parameters);
    }

}
