/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.viewpoint;

import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.browsing.ui.graph.impl.contribution.FinalViewpointContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

abstract public class ContextInputFinalViewpointContributorImpl implements Contributor<ViewpointContributionFactory> {

    abstract public Collection<?> getContribution(ReadGraph graph, NodeContext context);

    abstract public String getViewpointId();

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ContextInputFinalViewpointContributorImpl() {
        clazz = Object.class;
    }

    public ContextInputFinalViewpointContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ViewpointContributionFactory getFactory() {

        return new ViewpointContributionFactory() {

            @Override
            public String getViewpointId() {
                return ContextInputFinalViewpointContributorImpl.this.getViewpointId();
            }

            @Override
            public ViewpointContribution create(final PrimitiveQueryUpdater updater, NodeContext context, final ViewpointContributionKey key) {

                return new FinalViewpointContributionImpl(updater, context, key) {

                    @Override
                    public Collection<NodeContext> children(ReadGraph graph, NodeContext context) throws DatabaseException {

                        return NodeContextUtil.toContextCollectionWithInput(ContextInputFinalViewpointContributorImpl.this.getContribution(graph, context));


                    }

                    @Override
                    public Tester getNodeContextTester() {
                        return ContextInputFinalViewpointContributorImpl.this.getNodeContextTester();
                    }

                    @Override
                    public Class<?> getInputClass() {
                        return ContextInputFinalViewpointContributorImpl.this.getInputClass();
                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
