/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * A first test version of a viewpoint that provides editing of the shared
 * properties of multiple input resources.
 */
public class MultiInputPropertyViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(PrimitiveQueryUpdater provider, final NodeContext context, ViewpointKey key) {

        assert(provider != null);
        assert(context != null);

        return new LazyViewpoint(provider, context, key) {

            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
                Resource[] rs = (Resource[]) context.getConstant(BuiltinKeys.INPUT);
                if(rs.length == 0) return new NodeContext[0];
                if(rs.length == 1) return new NodeContext[0];
                Resource r = rs[0];
                Layer0 l0 = Layer0.getInstance(graph);
                Resource type = graph.getSingleType(r, l0.Entity);
                for(int i=1;i<rs.length;i++) {
                    Resource type2 = graph.getSingleType(rs[i], l0.Entity);
                    if(!type.equals(type2)) return new NodeContext[0];
                }

                Collection<Statement> children = graph.getStatements(r, l0.HasProperty);

                ArrayList<NodeContext> resultContexts = new ArrayList<NodeContext>();

                for(Statement child : children) {

                    ArrayList<Resource> objects = new ArrayList<Resource>();

                    objects.add(child.getObject());

                    boolean ok = true;
                    for(int i=1;i<rs.length;i++) {
                        Collection<Resource> objects2 = graph.getObjects(rs[1], child.getPredicate());
                        if(objects2.size() != 1) {
                            ok = false;
                            break;
                        }
                        objects.add(objects2.iterator().next());
                    }
                    if(ok) {
                        resultContexts.add(NodeContextBuilder.buildWithInput(new PropertyArray(child.getPredicate(), objects)));
                    }

                }

                return resultContexts.toArray(new NodeContext[resultContexts.size()]);
            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                return Boolean.valueOf(children(graph).length > 0);
            }
        };
    }

    @Override
    public String toString() {
        return "Properties";
    }

}
