/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

/**
 * A simple 16x16 white image descriptor for a missing image.
 * <p>
 * Use <code>MissingImageDescriptor.getInstance</code> to
 * access the singleton instance maintained in an
 * internal state variable.
 * </p>
 */
public class MissingImageDescriptor extends ImageDescriptor {
    private static MissingImageDescriptor instance;

    protected static final ImageData IMAGE_DATA = new ImageData(16, 16,
            1, new PaletteData(new RGB[] { new RGB(255, 255, 255) }));

    /**
     * Constructs a new default image descriptor.
     */
    private MissingImageDescriptor() {
        super();
    }

    /* (non-Javadoc)
     * Method declared on ImageDesciptor.
     */
    @Override
    public ImageData getImageData() {
        return IMAGE_DATA;
    }

    /**
     * Returns the shared default image descriptor instance.
     *
     * @return the image descriptor for a default image
     */
    public static MissingImageDescriptor getInstance() {
        if (instance == null) {
            instance = new MissingImageDescriptor();
        }
        return instance;
    }
}
