/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.representation.StringRepresentation2;
import org.simantics.utils.datastructures.slice.ValueRange;

/**
 * @author Tuukka Lehtonen
 */
public final class LabelerUtil {

    /**
     * @param g
     * @param r
     * @return
     */
    public static String safeStringRepresentation(ReadGraph g, Resource r) throws DatabaseException {
        try {
            String rep = g.adapt(r, String.class);
            return rep;
        } catch (AdaptionException e) {
            return "<no string representation: " + e.getMessage() + ">";
        } catch (DatabaseException e) {
            return NameUtils.getSafeName(g, r);
        }
    }

    /**
     * @param g
     * @param r
     * @param range
     * @return
     */
    public static String safeStringRepresentation(ReadGraph g, Resource r, int index) throws DatabaseException {
        try {
            StringRepresentation2 rep = g.adapt(r, StringRepresentation2.class);
            return rep.get(g, index);
        } catch (AdaptionException e) {
            return "<no string representation: " + e.getMessage() + ">";
        }
    }

    /**
     * @param g
     * @param r
     * @param range
     * @return
     */
    public static String safeStringRepresentation(ReadGraph g, Resource r, ValueRange range) throws DatabaseException {
        try {
            StringRepresentation2 rep = g.adapt(r, StringRepresentation2.class);
            return rep.get(g, range.start(), range.size());
        } catch (AdaptionException e) {
            return "<no string representation: " + e.getMessage() + ">";
        }
    }

}
