/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import org.simantics.browsing.ui.Column;

public class ColumnFactory {
    String key;
    String label;
    Column.Align alignment;
    int width;
    String tooltip;
    boolean grab = false;

    private ColumnFactory(String key) {
        this.key = key;
        this.alignment = Column.Align.LEFT;
        this.width = -1;
        this.tooltip = "";
    }

    private ColumnFactory(String key, Column.Align alignment, int width, String tooltip) {
        this.key = key;
        this.alignment = alignment;
        this.width = width;
        this.tooltip = tooltip;
    }

    public static ColumnFactory defaults(String key) {
        return new ColumnFactory(key);
    }

    public static ColumnFactory get(Column c) {
        return new ColumnFactory(c.getKey(), c.getAlignment(), c.getWidth(), c.getTooltip());
    }

    public ColumnFactory key(String key) {
        this.key = key;
        return this;
    }

    public ColumnFactory label(String label) {
        this.label = label;
        return this;
    }

    public ColumnFactory alignment(Column.Align alignment) {
        this.alignment = alignment;
        return this;
    }

    public ColumnFactory width(int width) {
        this.width = width;
        return this;
    }

    public ColumnFactory tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ColumnFactory grab() {
        this.grab = true;
        return this;
    }

    public Column toColumn() {
        return new Column(this.key, this.label, this.alignment, this.width, this.tooltip, this.grab);
    }
}

