/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;

public class DefaultLabelerProcessor extends AbstractPrimitiveQueryProcessor<Labeler> {

    @Override
    public Object getIdentifier() {
        return LabelerKey.class;
    }

    @Override
    public Labeler query(PrimitiveQueryUpdater updater, NodeContext context, PrimitiveQueryKey<Labeler> key) {
        LabelerKey k = (LabelerKey) key;
        final LabelerFactory factory = k.getParameter(0);
        if (factory == null)
            return null;
        return factory.create(updater, context, k);
    }

    @Override
    public String toString() {
        return "LabelerProcessor";
    }

}