/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;

public class DefaultImagerProcessor extends AbstractPrimitiveQueryProcessor<Imager> {

    @Override
    public Object getIdentifier() {
        return ImagerKey.class;
    }

    @Override
    public Imager query(PrimitiveQueryUpdater updater, NodeContext context, PrimitiveQueryKey<Imager> key) {
        ImagerKey k = (ImagerKey) key;
        final ImagerFactory factory = k.getParameter(0);
        if (factory == null)
            return null;
        return factory.create(updater, context, k);
    }

    @Override
    public String toString() {
        return "ImagerProcessor";
    }

}