/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.labelers;

import java.util.Map;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;

/**
 * A stub implementation of Labeler.
 * 
 * @author Tuukka Lehtonen
 */
/**
 * @author Jani Simomaa
 *
 */
public class LabelerStub implements Labeler {

    protected LabelerContent content = LabelerContent.NO_CONTENT;

    public LabelerStub() {
    }

    public LabelerStub(LabelerContent content) {
        if (content == null)
            throw new NullPointerException(this + " tried to initialize with null content");
        this.content = content;
    }

    public void setContent(LabelerContent content) {
        if (content == null)
            throw new NullPointerException(this + " tried to set null content");
        this.content = content;
    }

    @Override
    public Map<String, String> getLabels() {
        return content.labels;
    }

    @Override
    public Map<String, String> getRuntimeLabels() {
        return null;
    }

    @Override
    public int getCategory() {
        return content.category;
    }

    @Override
    public Modifier getModifier(ModificationContext context, String key) {
        return null;
    }

    @Override
    public void setListener(LabelerListener listener) {
    }

    /**
     * @param event
     * @param parent
     * @param nodeContext
     * @return
     */
    public Composite createToolTipContentArea(Event event, Composite parent, NodeContext nodeContext) {
        return null;
    }

    /**
     * @param event
     * @param nodeContext
     * @return
     */
    public boolean shouldCreateToolTip(Event event, NodeContext nodeContext) {
        return false;
    }
    
}
