/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.actions;

import java.util.Set;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 * @since 1.24.0
 */
public class CollapseSelected extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GraphExplorer explorer = HandlerUtil.getActivePart(event).getAdapter(GraphExplorer.class);
        if (explorer == null)
            return null;
        Set<NodeContext> nodes = ISelectionUtils.filterSetSelection(HandlerUtil.getCurrentSelection(event), NodeContext.class);
        if (nodes.isEmpty())
            return null;
        NodeContextUtil.collapseNodesUnder(explorer, nodes);
        return null;
    }

}
