/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.application.arguments;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.application.arguments.IArgument;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;

public class Arguments
implements IArguments {
    private Map<String, IArgument<?>> args = new TreeMap();

    @Override
    public void put(IArgument<?> arg) {
        this.args.put(arg.getArgument(), arg);
    }

    @Override
    public void putAll(IArguments args) {
        IArgument<?>[] iArgumentArray = args.toArray();
        int n = iArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArgument<?> arg = iArgumentArray[n2];
            this.put(arg);
            ++n2;
        }
    }

    @Override
    public <T> IArgument<T> remove(IArgumentFactory<T> key) {
        return this.args.remove(key.getArgument());
    }

    @Override
    public <T> boolean contains(IArgumentFactory<T> key) {
        return this.args.containsKey(key.getArgument());
    }

    @Override
    public <T> T get(IArgumentFactory<T> key) {
        IArgument<?> a = this.args.get(key.getArgument());
        return a == null ? null : (T)a.getValue();
    }

    @Override
    public <T> T get(IArgumentFactory<T> key, T defaultValue) {
        IArgument<?> a = this.args.get(key.getArgument());
        return (T)(a == null ? defaultValue : a.getValue());
    }

    @Override
    public IArgument<?>[] toArray() {
        int size = this.args.size();
        return this.args.values().toArray(new IArgument[size]);
    }

    public static IArguments parse(String[] args, IArgumentFactory<?> ... parsedArguments) {
        ListIterator<String> iter = Arrays.asList(args).listIterator();
        Arguments result = new Arguments();
        while (iter.hasNext()) {
            String arg = iter.next();
            IArgument<?> ret = null;
            IArgumentFactory<?>[] iArgumentFactoryArray = parsedArguments;
            int n = parsedArguments.length;
            int n2 = 0;
            while (n2 < n) {
                IArgumentFactory<?> factory = iArgumentFactoryArray[n2];
                try {
                    ret = factory.parse(arg, iter);
                    if (ret != null) {
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n2;
            }
            if (ret == null) continue;
            result.put(ret);
        }
        return result;
    }
}

