package org.simantics.action.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ActionResource {
    
    public final Resource Action;
    public final Resource DropAction;
        
    public static class URIs {
        public static final String Action = "http://www.simantics.org/Action-1.1/Action";
        public static final String DropAction = "http://www.simantics.org/Action-1.1/DropAction";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ActionResource(ReadGraph graph) {
        Action = getResourceOrNull(graph, URIs.Action);
        DropAction = getResourceOrNull(graph, URIs.DropAction);
    }
    
    public static ActionResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ActionResource ret = session.peekService(ActionResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ActionResource(qc.getIndependentGraph(graph));
            session.registerService(ActionResource.class, ret);
        }
        return ret;
    }
    
    public static ActionResource getInstance(RequestProcessor session) throws DatabaseException {
        ActionResource ret = session.peekService(ActionResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<ActionResource>() {
                public ActionResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ActionResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ActionResource.class, ret);
        }
        return ret;
    }
    
}

