/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.HeadState;
import org.simantics.acorn.exception.InvalidHeadStateException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.binary.BinaryMemory;

public class HeadState1 {
    public static final String HEAD_STATE = "head.state";
    public static final String SHA_1 = "SHA-1";
    public int headChangeSetId = 0;
    public long transactionId = 1L;
    public long reservedIds = 3L;
    public ArrayList<String> clusters = new ArrayList();
    public ArrayList<String> files = new ArrayList();
    public ArrayList<String> stream = new ArrayList();
    public ArrayList<String> cs = new ArrayList();

    public HeadState migrate() {
        HeadState state = new HeadState();
        state.headChangeSetId = this.headChangeSetId;
        state.transactionId = this.transactionId;
        state.reservedIds = this.reservedIds;
        state.clusters = this.clusters;
        state.files = this.files;
        state.stream = this.stream;
        state.cs = this.cs;
        return state;
    }

    public static HeadState1 load(Path directory) throws InvalidHeadStateException {
        Path f = directory.resolve(HEAD_STATE);
        try {
            byte[] bytes = Files.readAllBytes(f);
            MessageDigest sha1 = MessageDigest.getInstance(SHA_1);
            int digestLength = sha1.getDigestLength();
            sha1.update(bytes, digestLength, bytes.length - digestLength);
            byte[] newChecksum = sha1.digest();
            if (!Arrays.equals(newChecksum, Arrays.copyOfRange(bytes, 0, digestLength))) {
                throw new InvalidHeadStateException("Checksum " + Arrays.toString(newChecksum) + " does not match excpected " + Arrays.toString(Arrays.copyOfRange(bytes, 0, digestLength)) + " for " + f.toAbsolutePath());
            }
            Throwable throwable = null;
            Object var7_10 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes, digestLength, bytes.length - digestLength);){
                HeadState1 object = (HeadState1)org.simantics.databoard.Files.readFile((InputStream)bais, (Binding)Bindings.getBindingUnchecked(HeadState1.class));
                return object;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return new HeadState1();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 Algorithm not found", e);
        }
        catch (Throwable t) {
            throw new InvalidHeadStateException(t);
        }
    }

    public void save(Path directory) throws IOException {
        Path f = directory.resolve(HEAD_STATE);
        try {
            try (BinaryMemory rf = new BinaryMemory(4096);){
                MutableVariant v = new MutableVariant(Bindings.getBindingUnchecked(HeadState1.class), (Object)this);
                Serializer s = Bindings.getSerializerUnchecked((Binding)Bindings.VARIANT);
                s.serialize((DataOutput)rf, (Object)v);
            }
            byte[] bytes = rf.toByteBuffer().array();
            MessageDigest sha1 = MessageDigest.getInstance(SHA_1);
            sha1.update(bytes);
            byte[] checksum = sha1.digest();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream out = Files.newOutputStream(f, new OpenOption[0]);){
                out.write(checksum);
                out.write(bytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            FileIO.syncPath(f);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 digest not found, should not happen", e);
        }
    }

    public static void validateHeadStateIntegrity(Path headState) throws InvalidHeadStateException, IOException {
        try {
            byte[] bytes = Files.readAllBytes(headState);
            MessageDigest sha1 = MessageDigest.getInstance(SHA_1);
            int digestLength = sha1.getDigestLength();
            sha1.update(bytes, digestLength, bytes.length - digestLength);
            byte[] newChecksum = sha1.digest();
            if (!Arrays.equals(newChecksum, Arrays.copyOfRange(bytes, 0, digestLength))) {
                throw new InvalidHeadStateException("Checksum " + Arrays.toString(newChecksum) + " does not match excpected " + Arrays.toString(Arrays.copyOfRange(bytes, 0, digestLength)) + " for " + headState.toAbsolutePath());
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 digest not found, should not happen", e);
        }
    }
}

