package org.simantics.acorn;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import org.simantics.db.Disposable;

/**
 * @author Tuukka Lehtonen
 * @since 1.32.0
 */
public class FileCache implements Disposable {

	private Map<Path, FileIO> map = new HashMap<>();

	public FileIO get(Path path) {
		synchronized (map) {
			return map.computeIfAbsent(path, FileIO::new);
		}
	}

	@Override
	public void dispose() {
		map = new HashMap<>();
	}

}
