/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenSystemEditorAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileAction
extends OpenSystemEditorAction {
    public static final String ID = "org.eclipse.ui.OpenFileAction";
    private IEditorDescriptor editorDescriptor;

    public OpenFileAction(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenFileAction(IWorkbenchPage page, IEditorDescriptor descriptor) {
        super(page);
        this.setText(descriptor == null ? IDEWorkbenchMessages.OpenFileAction_text : descriptor.getLabel());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_file_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenFileAction_toolTip);
        this.setId(ID);
        this.editorDescriptor = descriptor;
    }

    boolean ensureFileLocal(IFile file) {
        return true;
    }

    @Override
    void openFile(IFile file) {
        try {
            boolean activate = OpenStrategy.activateOnOpen();
            if (this.editorDescriptor == null) {
                IDE.openEditor(this.getWorkbenchPage(), file, activate);
            } else if (this.ensureFileLocal(file)) {
                this.getWorkbenchPage().openEditor((IEditorInput)new FileEditorInput(file), this.editorDescriptor.getId(), activate);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError(this.getWorkbenchPage().getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenFileAction_openFileShellTitle, e.getMessage(), e);
        }
    }
}

