/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pgroup;

import org.eclipse.nebula.widgets.pgroup.AbstractGroupStrategy;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.nebula.widgets.pgroup.internal.TextUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SimpleGroupStrategy
extends AbstractGroupStrategy {
    private int separatorHeight = 2;
    private int heightWithoutLine = 0;
    private int lineMargin = 2;
    private int lineBetweenSpacing = 8;
    private int titleTextMargin = 0;
    private int betweenSpacing = 6;
    private int vMargin = 3;
    private int hMargin = 3;
    private int titleHeight;
    private int textWidth;
    private int fontHeight;

    public SimpleGroupStrategy() {
        this(null);
    }

    public SimpleGroupStrategy(PGroup g) {
        super(g);
    }

    public void paint(GC gc) {
        Color back = this.getGroup().internalGetBackground();
        if (back != null) {
            gc.fillRectangle(0, 0, this.getGroup().getSize().x, this.getGroup().getSize().y);
        }
        if (this.getGroup().getToggleRenderer() != null) {
            int toggleY = 0;
            toggleY = this.getGroup().getLinePosition() == 0x1000000 ? (this.heightWithoutLine - this.getGroup().getToggleRenderer().getSize().y) / 2 : this.heightWithoutLine - this.getGroup().getToggleRenderer().getSize().y - this.vMargin;
            if ((this.getGroup().getTogglePosition() & 0x4000) != 0) {
                this.getGroup().getToggleRenderer().setLocation(new Point(this.hMargin, toggleY));
            } else {
                this.getGroup().getToggleRenderer().setLocation(new Point(this.getGroup().getSize().x - this.hMargin - this.getGroup().getToggleRenderer().getSize().x, toggleY));
            }
        }
        if (this.getGroup().getImage() != null) {
            int imgX = 0;
            int imgY = 0;
            if ((this.getGroup().getImagePosition() & 0x4000) != 0) {
                imgX = this.hMargin;
                if ((this.getGroup().getTogglePosition() & 0x4000) != 0 && this.getGroup().getToggleRenderer() != null) {
                    imgX += this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
                }
            } else {
                imgX = this.getGroup().getSize().x - this.getGroup().getImage().getBounds().width - this.hMargin;
                if ((this.getGroup().getTogglePosition() & 0x4000) == 0 && this.getGroup().getToggleRenderer() != null) {
                    imgX -= this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
                }
            }
            imgY = this.getGroup().getLinePosition() == 0x1000000 ? (this.heightWithoutLine - this.getGroup().getImage().getBounds().height) / 2 : this.heightWithoutLine - this.getGroup().getImage().getBounds().height - this.vMargin;
            gc.drawImage(this.getGroup().getImage(), imgX, imgY);
        }
        Rectangle textBounds = this.getTextBounds();
        gc.drawString(TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width), textBounds.x, textBounds.y, true);
        int x = 0;
        int x2 = 0;
        int y = 0;
        if (this.getGroup().getLinePosition() == 1024) {
            x = 0;
            x2 = this.getGroup().getSize().x;
            y = this.titleHeight - this.separatorHeight - this.lineMargin;
        } else {
            Point p = gc.stringExtent(TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width));
            x = textBounds.x + p.x + this.lineBetweenSpacing;
            x2 = textBounds.x + p.x + this.betweenSpacing + (textBounds.width - p.x) - this.lineBetweenSpacing;
            y = textBounds.y + p.y / 2;
        }
        if (x2 > x) {
            gc.setForeground(this.getGroup().getDisplay().getSystemColor(18));
            gc.drawLine(x, y, x2, y);
            gc.setForeground(this.getGroup().getDisplay().getSystemColor(20));
            gc.drawLine(x, y + 1, x2, y + 1);
        }
        if (!this.getGroup().getExpanded()) {
            gc.setBackground(this.getGroup().getParent().getBackground());
        }
    }

    public boolean isToggleLocation(int x, int y) {
        if (super.isToggleLocation(x, y)) {
            return true;
        }
        if (this.getGroup().getToggleRenderer() == null) {
            return false;
        }
        Rectangle textBounds = this.getTextBounds();
        textBounds.width = Math.min(this.textWidth, textBounds.width);
        return textBounds.contains(x, y);
    }

    private Rectangle getTextBounds() {
        int toggleHeight;
        int textX = this.hMargin;
        if ((this.getGroup().getImagePosition() & 0x4000) != 0 && this.getGroup().getImage() != null) {
            textX += this.getGroup().getImage().getBounds().width + this.betweenSpacing;
        }
        if ((this.getGroup().getTogglePosition() & 0x4000) != 0 && this.getGroup().getToggleRenderer() != null) {
            textX += this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
        }
        int textWidth = this.getGroup().getSize().x - textX - this.hMargin;
        if ((this.getGroup().getImagePosition() & 0x4000) == 0 && this.getGroup().getImage() != null) {
            textWidth -= this.getGroup().getImage().getBounds().width + this.betweenSpacing;
        }
        if ((this.getGroup().getTogglePosition() & 0x4000) == 0 && this.getGroup().getToggleRenderer() != null) {
            textWidth -= this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
        }
        int textY = 0;
        textY = this.getGroup().getLinePosition() == 0x1000000 ? (this.heightWithoutLine - this.fontHeight) / 2 : this.heightWithoutLine - (this.fontHeight + this.titleTextMargin + this.vMargin);
        if (this.getGroup().getToggleRenderer() != null && (toggleHeight = this.getGroup().getToggleRenderer().getSize().y) > this.fontHeight) {
            int toggleY = (this.heightWithoutLine - toggleHeight) / 2;
            int difference = (toggleHeight - this.fontHeight) / 2;
            textY = toggleY + difference;
        }
        return new Rectangle(textX, textY, textWidth, this.fontHeight);
    }

    public Rectangle getClientArea() {
        Rectangle area = this.getGroup().getBounds();
        area.x = 0;
        area.y = this.titleHeight;
        area.height -= this.titleHeight;
        return area;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle area = new Rectangle(x, y, width, height);
        area.y -= this.titleHeight;
        area.height += this.titleHeight;
        return area;
    }

    public void dispose() {
    }

    public void update() {
        GC gc = new GC((Drawable)this.getGroup());
        this.titleHeight = 0;
        int imageHeight = 0;
        if (this.getGroup().getImage() != null) {
            imageHeight = this.getGroup().getImage().getBounds().height;
        }
        this.titleHeight = Math.max(gc.getFontMetrics().getHeight() + 2 * this.titleTextMargin + 2 * this.vMargin, imageHeight + 2 * this.vMargin);
        if (this.getGroup().getToggleRenderer() != null) {
            int toggleHeight = this.getGroup().getToggleRenderer().getSize().y + 2 * this.vMargin;
            this.titleHeight = Math.max(toggleHeight + 2 * this.vMargin, this.titleHeight);
        }
        this.heightWithoutLine = this.titleHeight;
        if (this.getGroup().getLinePosition() == 1024) {
            this.titleHeight += this.separatorHeight;
            this.titleHeight += 2 * this.lineMargin;
        }
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.textWidth = gc.stringExtent((String)this.getGroup().getText()).x;
        gc.dispose();
    }
}

