/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base.datatypes.literal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

public class Time
extends Bean
implements org.simantics.xml.sax.base.datatypes.adt.Time {
    public static final Binding BINDING = Bindings.getBindingUnchecked(Time.class);
    public byte hours;
    public byte minutes;
    public byte seconds;
    public int offset;

    public Time() {
        super(BINDING);
    }

    public Time(int hours, int minutes, int seconds) {
        this(hours, minutes, seconds, Integer.MIN_VALUE);
    }

    public Time(int hours, int minutes, int seconds, int offset) {
        super(BINDING);
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Hours must be between 0 - 23, got " + hours);
        }
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Minutes must be between 0 - 59, got " + minutes);
        }
        if (seconds < 0 || seconds > 59) {
            throw new IllegalArgumentException("Seconds must be between 0 - 59, got " + seconds);
        }
        this.hours = (byte)hours;
        this.minutes = (byte)minutes;
        this.seconds = (byte)seconds;
        this.offset = offset;
    }

    @Override
    public int getHours() {
        return this.hours;
    }

    @Override
    public int getMinutes() {
        return this.minutes;
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }

    @Override
    public int getTimezoneOffset() {
        return this.offset;
    }

    @Override
    public Date getJavaDate() {
        Calendar c = Calendar.getInstance();
        c.set(11, this.hours);
        c.set(12, this.minutes);
        c.set(13, this.seconds);
        if (this.offset != Integer.MIN_VALUE) {
            c.setTimeZone(TimeZone.getTimeZone(TimeZone.getAvailableIDs(this.offset * 60 * 1000)[0]));
        }
        return c.getTime();
    }

    @Override
    public int compare(org.simantics.xml.sax.base.datatypes.adt.Time o) {
        if (this.getHours() != o.getHours()) {
            return this.getHours() - o.getHours();
        }
        if (this.getMinutes() != o.getMinutes()) {
            return this.getMinutes() - o.getMinutes();
        }
        if (this.getSeconds() != o.getSeconds()) {
            return this.getSeconds() - o.getSeconds();
        }
        return 0;
    }

    public static Time parseTime(String timeString) {
        String[] formats = new String[]{"HH:mm:ss.SSSSSSSXXX", "HH:mm:ss.SSSSSSS", "HH:mm:ss.SSXXX", "HH:mm:ss.SS", "HH:mm:ssXXX", "HH:mm:ss"};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[2] = true;
        blArray[4] = true;
        boolean[] timezone = blArray;
        int i = 0;
        while (i < formats.length) {
            String format = formats[i];
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                Date n = dateFormat.parse(timeString);
                if (timezone[i]) {
                    return new Time(n.getHours(), n.getMinutes(), n.getSeconds(), n.getTimezoneOffset());
                }
                return new Time(n.getHours(), n.getMinutes(), n.getSeconds());
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        throw new IllegalArgumentException("Time is not in proper format " + timeString);
    }

    public String toString() {
        return String.valueOf(this.hours < 10 ? "0" : "") + this.hours + ":" + (this.minutes < 10 ? "0" : "") + this.minutes + ":" + (this.seconds < 10 ? "0" : "") + this.seconds;
    }
}

