/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.xmlio;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.xmlio.DefaultLoadRule;
import org.simantics.layer0.Layer0;

public class MigrateLoadRule
extends DefaultLoadRule {
    Set<String> ontologies = new HashSet<String>();
    Map<String, String> ontologyVersions = new HashMap<String, String>();

    public MigrateLoadRule(ReadGraph graph) throws DatabaseException {
        Resource root = graph.getSession().getRootLibrary();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource lib : graph.getObjects(root, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(lib, l0.Library)) continue;
            for (Resource ontology : graph.getObjects(lib, l0.ConsistsOf)) {
                if (!graph.isInstanceOf(ontology, l0.Ontology)) continue;
                String uri = graph.getURI(ontology);
                String[] parsed = this.parse(uri);
                this.ontologies.add(parsed[0]);
                this.ontologyVersions.put(parsed[0], parsed[1]);
            }
        }
    }

    @Override
    public Resource getResource(ReadGraph graph, String uri) throws DatabaseException {
        return super.getResource(graph, this.getUri(uri));
    }

    private String getUri(String uri) {
        String[] parsed = this.parse(uri);
        String currentUri = String.valueOf(parsed[0]) + "-" + this.ontologyVersions.get(parsed[0]) + "/" + parsed[2];
        return currentUri;
    }

    private String[] parse(String uri) {
        int startVer = uri.indexOf("-");
        int endVer = uri.indexOf("/", startVer);
        if (endVer == -1) {
            return new String[]{uri.substring(0, startVer), uri.substring(startVer + 1)};
        }
        return new String[]{uri.substring(0, startVer), uri.substring(startVer + 1, endVer), uri.substring(endVer + 1)};
    }

    @Override
    public Object createValue(ReadGraph graph, List<String> value, List<String> types) throws DatabaseException {
        int i = 0;
        while (i < types.size()) {
            types.set(i, this.getUri(types.get(i)));
            ++i;
        }
        return super.createValue(graph, value, types);
    }
}

