/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.UpdateNode;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.interop.update.model.UpdateOperations;
import org.simantics.interop.update.model.UpdateStatus;

public class UpdateTree {
    private UpdateNode rootNode;
    private Map<Resource, UpdateNode> nodes;
    private GraphChanges changes;
    private UpdateOperations updateOps;

    public UpdateTree(ReadGraph g, GraphChanges changes, UpdateOperations updateOps) throws DatabaseException {
        this.changes = changes;
        this.nodes = new HashMap<Resource, UpdateNode>();
        this.rootNode = this.createNode(g, UpdateStatus.EXIST, changes.getResource1());
        this.nodes.put(changes.getResource1(), this.rootNode);
        this.nodes.put(changes.getResource2(), this.rootNode);
        this.updateOps = updateOps;
        this.updateOps.populate(g);
        this.populate(g);
    }

    public UpdateOperations getUpdateOps() {
        return this.updateOps;
    }

    public UpdateNode getRootNode() {
        return this.rootNode;
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    protected UpdateNode createNode(ReadGraph g, UpdateStatus status, Resource r) throws DatabaseException {
        return new UpdateNode(g, status, r);
    }

    protected UpdateNode createNode(ReadGraph g, UpdateStatus status, UpdateOp op) throws DatabaseException {
        return new UpdateNode(g, status, op);
    }

    private UpdateNode createNode(ReadGraph g, Resource r1, Resource r2) throws DatabaseException {
        UpdateNode node = null;
        if (r1 != null && r2 != null) {
            UpdateOp op = this.updateOps.getUpdateOp(r1);
            if (op == null) {
                op = this.updateOps.getUpdateOp(r2);
            }
            node = op == null ? this.createNode(g, UpdateStatus.EXIST, r1) : this.createNode(g, UpdateStatus.EXIST, op);
            this.nodes.put(r1, node);
            this.nodes.put(r2, node);
        } else if (r1 != null) {
            node = this.createNode(g, UpdateStatus.DELETED, this.updateOps.getUpdateOp(r1));
            this.nodes.put(r1, node);
        } else if (r2 != null) {
            node = this.createNode(g, UpdateStatus.NEW, this.updateOps.getUpdateOp(r2));
            this.nodes.put(r2, node);
        }
        return node;
    }

    public UpdateNode addNode(ReadGraph g, Resource r1, Resource r2) throws DatabaseException {
        if (this.nodes.containsKey(r1)) {
            return this.nodes.get(r1);
        }
        if (this.nodes.containsKey(r2)) {
            return this.nodes.get(r2);
        }
        UpdateNode node = this.createNode(g, r1, r2);
        this.connectParent(g, node);
        return node;
    }

    public UpdateNode getNode(Resource r) {
        return this.nodes.get(r);
    }

    protected boolean connectParent(ReadGraph g, UpdateNode node) throws DatabaseException {
        Resource parentResource;
        UpdateNode parent = null;
        while ((parent = this.nodes.get(parentResource = node.getParentResource(g))) == null) {
            parent = this.getOrCreate(g, parentResource);
            if (parent == null) {
                return false;
            }
            parent.addChild(node);
            node = parent;
            parent = null;
        }
        parent.addChild(node);
        return true;
    }

    protected UpdateNode getOrCreate(ReadGraph g, Resource parentResource) throws DatabaseException {
        UpdateNode parent = this.nodes.get(parentResource);
        if (parent == null) {
            if (this.changes.getComparable().containsLeft((Object)parentResource)) {
                parent = this.createNode(g, parentResource, (Resource)this.changes.getComparable().getRight((Object)parentResource));
            } else if (this.changes.getComparable().containsRight((Object)parentResource)) {
                parent = this.createNode(g, (Resource)this.changes.getComparable().getLeft((Object)parentResource), parentResource);
            } else {
                return null;
            }
        }
        return parent;
    }

    protected boolean handleCustom(ReadGraph g, UpdateOp op) throws DatabaseException {
        return false;
    }

    private void populate(ReadGraph g) throws DatabaseException {
        for (UpdateOp op : this.updateOps.getOperations()) {
            if (this.handleCustom(g, op)) continue;
            if (op.isAdd()) {
                this.addNode(g, null, op.getResource());
                continue;
            }
            if (op.isDelete()) {
                this.addNode(g, op.getResource(), null);
                continue;
            }
            if (!op.isChange()) continue;
            Resource l = this.getChanges().getComparable().containsLeft((Object)op.getResource()) ? op.getResource() : (Resource)this.getChanges().getComparable().getLeft((Object)op.getResource());
            Resource r = this.getChanges().getComparable().containsRight((Object)op.getResource()) ? op.getResource() : (Resource)this.getChanges().getComparable().getRight((Object)op.getResource());
            this.addNode(g, l, r);
        }
    }
}

