/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.interop.diagram.DiagramUtils;
import org.simantics.interop.diagram.Symbol;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.page.PageDesc;

public abstract class Diagram<T extends Symbol> {
    public static boolean DO_NO_MIX_SECTION_NAMES = false;
    public static boolean USE_MERGE_CONNECTS = true;
    private Resource composite;
    private Resource diagram;
    private Map<Resource, Integer> indexMap = new HashMap<Resource, Integer>();
    private Map<Resource, T> elementToSymbolMap = new HashMap<Resource, T>();
    private Map<Resource, Diagram<T>> compositeToDiagramMap = new HashMap<Resource, Diagram<T>>();

    protected Diagram(ReadGraph g, Resource composite, Resource diagram) throws DatabaseException {
        this.composite = composite;
        this.diagram = diagram;
    }

    protected abstract Diagram<T> construct(ReadGraph var1, Resource var2, Resource var3) throws DatabaseException;

    protected abstract T constructSymbol(ReadGraph var1, Resource var2, Resource var3) throws DatabaseException;

    public Resource getComposite() {
        return this.composite;
    }

    public Resource getDiagram() {
        return this.diagram;
    }

    public void clearCaches() {
        for (Diagram<T> d : this.compositeToDiagramMap.values()) {
            for (Symbol s : d.elementToSymbolMap.values()) {
                s.dispose();
            }
            d.elementToSymbolMap.clear();
        }
        this.compositeToDiagramMap.clear();
    }

    public String generateName(ReadGraph g, Resource type, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Layer0X l0x = Layer0X.getInstance((ReadGraph)g);
        String prefix = (String)g.getPossibleRelatedValue(type, l0x.HasGeneratedNamePrefix);
        if (prefix == null || prefix.length() == 0) {
            prefix = (String)g.getRelatedValue(type, l0.HasName);
        }
        prefix = String.valueOf(prefix) + "_";
        Set<String> reserved = null;
        if (name != null) {
            String toTry;
            reserved = this.getAllModuleNamesForModel(g, this.composite);
            int index = 0;
            String realname = String.valueOf(name) + "_" + prefix;
            while (reserved.contains(toTry = String.valueOf(realname) + Integer.toString(index))) {
                ++index;
            }
            realname = String.valueOf(realname) + Integer.toString(index);
            return realname;
        }
        Integer index = this.indexMap.get(type);
        if (index != null) {
            index = index + 1;
        } else {
            String toTry;
            if (reserved == null) {
                reserved = this.getAllModuleNamesForModel(g, this.composite);
            }
            index = 0;
            while (reserved.contains(toTry = String.valueOf(prefix) + Integer.toString(index))) {
                index = index + 1;
            }
        }
        this.indexMap.put(type, index);
        return String.valueOf(prefix) + index;
    }

    private Set<String> getAllModuleNamesForModel(ReadGraph graph, Resource res) throws DatabaseException {
        Resource model = DiagramUtils.getModel(graph, res);
        Resource configuration = DiagramUtils.getConfiguration(graph, model);
        HashSet<String> names = new HashSet<String>();
        if (configuration == null) {
            return names;
        }
        Collection<Resource> composites = this.getAllComposites((RequestProcessor)graph, configuration);
        for (Resource composite : composites) {
            names.addAll(this.getAllModuleNamesForComposite((RequestProcessor)graph, composite));
        }
        return names;
    }

    protected abstract Resource getGraphicalCompositeType(ReadGraph var1) throws DatabaseException;

    protected abstract Resource getFolderType(ReadGraph var1) throws DatabaseException;

    private Collection<Resource> getAllComposites(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (Set)processor.syncRequest((Read)new ResourceRead<Object>(configuration){

            public Object perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                HashSet<Resource> composites = new HashSet<Resource>();
                Stack<Resource> resources = new Stack<Resource>();
                Resource graphicalCompositeType = Diagram.this.getGraphicalCompositeType(graph);
                Resource folderType = Diagram.this.getFolderType(graph);
                resources.add(this.resource);
                while (!resources.isEmpty()) {
                    Resource r = (Resource)resources.pop();
                    if (graph.isInstanceOf(r, graphicalCompositeType)) {
                        composites.add(r);
                        continue;
                    }
                    if (folderType == null || !graph.isInstanceOf(r, folderType)) continue;
                    resources.addAll(graph.getObjects(r, l0.ConsistsOf));
                }
                return composites;
            }
        }, (Listener)TransientCacheListener.instance());
    }

    private Set<String> getAllModuleNamesForComposite(RequestProcessor processor, Resource composite) throws DatabaseException {
        return (Set)processor.syncRequest((Read)new ResourceRead<Object>(composite){

            public Object perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                HashSet<String> names = new HashSet<String>();
                Collection components = graph.getObjects(this.resource, l0.ConsistsOf);
                for (Resource component : components) {
                    String n = (String)graph.getPossibleRelatedValue(component, l0.HasName, (Binding)Bindings.STRING);
                    if (n == null) continue;
                    names.add(n);
                }
                return names;
            }
        }, (Listener)TransientCacheListener.instance());
    }

    public Diagram<T> createDiagram(WriteGraph g, String name, Resource compositeType, Resource parent) throws DatabaseException {
        return this.createDiagram(g, name, null, null, compositeType, parent);
    }

    public Diagram<T> createDiagram(WriteGraph g, String name, DiagramDesc desc, Template tpl, Resource compositeType, Resource parent) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Layer0X l0x = Layer0X.getInstance((ReadGraph)g);
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        DiagramResource dia = DiagramResource.getInstance((ReadGraph)g);
        Resource composite = g.newResource();
        g.claim(composite, l0.InstanceOf, compositeType);
        Resource diagramType = this.getDiagramFromComposite((ReadGraph)g, compositeType);
        Resource diagram = OrderedSetUtils.create((WriteOnlyGraph)g, (Resource)diagramType);
        g.claim(composite, m.CompositeToDiagram, diagram);
        g.claimLiteral(composite, l0.HasName, (Object)name);
        g.claim(composite, l0.PartOf, parent);
        Resource mapping = g.newResource();
        g.claim(mapping, l0.InstanceOf, m.DiagramToCompositeMapping);
        g.claim(diagram, l0x.HasTrigger, mapping);
        if (tpl != null) {
            HashMap<String, Resource> params = new HashMap<String, Resource>();
            params.put("diagram", diagram);
            tpl.apply(g, params);
        }
        g.claimLiteral(diagram, l0.HasName, (Object)name, (Binding)Bindings.STRING);
        Resource container = g.newResource();
        g.claim(container, l0.InstanceOf, null, dia.DiagramContainer);
        g.addLiteral(container, l0.HasName, l0.NameOf, l0.String, (Object)"__CONTAINER__", (Binding)Bindings.STRING);
        g.claim(container, l0.ConsistsOf, diagram);
        g.claim(composite, l0.ConsistsOf, container);
        if (desc != null) {
            DiagramGraphUtil.setDiagramDesc((WriteGraph)g, (Resource)diagram, (DiagramDesc)desc);
        }
        Diagram<T> diag = this.construct((ReadGraph)g, composite, diagram);
        diag.compositeToDiagramMap = this.compositeToDiagramMap;
        this.compositeToDiagramMap.put(composite, diag);
        return diag;
    }

    public Diagram<T> fromExisting(ReadGraph g, Resource diagram) throws DatabaseException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        StructuralResource2 s = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        Resource composite = null;
        if (g.isInstanceOf(diagram, s.Composite) ? (diagram = g.getPossibleObject(composite = diagram, m.CompositeToDiagram)) == null : (g.isInheritedFrom(diagram, d.DefinedElement) ? (diagram = g.getPossibleObject(composite = diagram, s.IsDefinedBy)) == null : (composite = g.getPossibleObject(diagram, m.DiagramToComposite)) == null)) {
            return null;
        }
        Diagram<T> diag = this.compositeToDiagramMap.get(composite);
        if (diag != null) {
            return diag;
        }
        diag = this.construct(g, composite, diagram);
        diag.compositeToDiagramMap = this.compositeToDiagramMap;
        this.compositeToDiagramMap.put(composite, diag);
        return diag;
    }

    public Resource getDiagramFromComposite(ReadGraph g, Resource compositeType) throws DatabaseException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        Collection diagramTemplates = g.getAssertedObjects(compositeType, m.HasModelingTemplate);
        for (Resource diagramTemplate : diagramTemplates) {
            Resource diagramType = g.getPossibleObject(diagramTemplate, m.HasDiagramType);
            if (diagramType == null) continue;
            return diagramType;
        }
        throw new RuntimeException("Cannot find diagramType for composite " + compositeType);
    }

    public T addSymbol(WriteGraph g, Resource symbolType) throws DatabaseException {
        return this.addSymbol(g, symbolType, 0.0, 0.0);
    }

    public T addSymbol(WriteGraph g, Resource symbolType, String name) throws DatabaseException {
        return this.addSymbol(g, symbolType, name, 0.0, 0.0);
    }

    public T addSymbol(WriteGraph g, Resource symbolType, double x, double y) throws DatabaseException {
        return this.addSymbol(g, symbolType, null, x, y);
    }

    public T addSymbol(WriteGraph g, Resource elementType, String name, double x, double y) throws DatabaseException {
        if (elementType == null) {
            throw new NullPointerException("Element type is null");
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        Resource componentType = null;
        if (g.isInheritedFrom(elementType, d.DefinedElement)) {
            componentType = Symbol.getComponentTypeFromSymbolType((ReadGraph)g, elementType);
        } else {
            componentType = elementType;
            elementType = Symbol.getSymbolTypeFromComponentType((ReadGraph)g, componentType);
        }
        Resource element = g.newResource();
        g.claim(element, l0.InstanceOf, elementType);
        Resource module = g.newResource();
        g.claim(module, l0.InstanceOf, componentType);
        g.claim(module, m.ComponentToElement, element);
        g.claim(module, m.Mapped, module);
        String id = this.generateName((ReadGraph)g, componentType, name);
        g.claimLiteral(module, l0.HasName, (Object)id);
        g.claimLiteral(element, l0.HasName, (Object)id);
        OrderedSetUtils.add((WriteGraph)g, (Resource)this.diagram, (Resource)element);
        g.claim(this.diagram, l0.ConsistsOf, element);
        g.claim(this.composite, l0.ConsistsOf, module);
        T s = this.constructSymbol((ReadGraph)g, element, module);
        ((Symbol)s).setSymbolTranslation(g, x, y);
        this.elementToSymbolMap.put(element, s);
        return s;
    }

    public T getSymbol(ReadGraph g, Resource element) throws DatabaseException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        StructuralResource2 s = StructuralResource2.getInstance((ReadGraph)g);
        if (g.isInstanceOf(element, dr.Element)) {
            return this.getSymbol(g, element, g.getPossibleObject(element, mr.ElementToComponent));
        }
        if (g.isSubrelationOf(element, s.IsConnectedTo)) {
            return this.getSymbol(g, g.getSingleObject(element, dr.HasConnectionPoint_Inverse), element);
        }
        return this.getSymbol(g, g.getSingleObject(element, mr.ComponentToElement), element);
    }

    public T getSymbol(ReadGraph g, Resource element, Resource component) throws DatabaseException {
        Symbol s = (Symbol)this.elementToSymbolMap.get(element);
        if (s == null) {
            s = this.constructSymbol(g, element, component);
            this.elementToSymbolMap.put(element, s);
        } else if (s.component == null) {
            s.component = component;
        } else if (!s.component.equals(component)) {
            return this.constructSymbol(g, element, component);
        }
        return (T)s;
    }

    public T addElement(WriteGraph g, Resource symbolType, double x, double y) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Resource element = g.newResource();
        g.claim(element, l0.InstanceOf, symbolType);
        DiagramUtils.addElement(g, this, element);
        T s = this.constructSymbol((ReadGraph)g, element, null);
        ((Symbol)s).setSymbolTranslation(g, x, y);
        this.elementToSymbolMap.put(element, s);
        return s;
    }

    public T getSingleSymbol(ReadGraph g, String symbolName) throws DatabaseException {
        List<T> matching = this.getSymbol(g, symbolName);
        if (matching.size() == 1) {
            return (T)((Symbol)matching.get(0));
        }
        if (matching.size() == 0) {
            return null;
        }
        throw new NoSingleResultException("There are multiple symbols with name '" + symbolName);
    }

    public T getPossibleSymbol(ReadGraph g, String symbolName) throws DatabaseException {
        List<T> matching = this.getSymbol(g, symbolName);
        if (matching.size() == 1) {
            return (T)((Symbol)matching.get(0));
        }
        return null;
    }

    public List<T> getSymbols(ReadGraph g) throws DatabaseException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        ArrayList<T> matching = new ArrayList<T>();
        for (Resource element : OrderedSetUtils.toList((ReadGraph)g, (Resource)this.diagram)) {
            Resource component = g.getPossibleObject(element, m.ElementToComponent);
            matching.add(this.getSymbol(g, element, component));
        }
        return matching;
    }

    public List<T> getSymbol(ReadGraph g, String symbolName) throws DatabaseException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        ArrayList<T> matching = new ArrayList<T>();
        String[] splitId = symbolName.split(";");
        for (Resource element : OrderedSetUtils.toList((ReadGraph)g, (Resource)this.diagram)) {
            Resource component = g.getPossibleObject(element, m.ElementToComponent);
            if (component == null) {
                component = g.getPossibleObject(element, m.HasParentComponent);
            }
            if (component == null) continue;
            String label = (String)g.getPossibleRelatedValue(component, b.HasLabel);
            String name = (String)g.getRelatedValue(component, b.HasName);
            if (label != null) {
                Object[] splitLabel = label.split(";");
                boolean match = true;
                int i = 0;
                while (i < splitId.length) {
                    if (!Arrays.contains((Object[])splitLabel, (Object)splitId[i])) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (match) {
                    matching.add(this.getSymbol(g, element, component));
                    continue;
                }
                if (!label.equals(symbolName) && !name.equals(symbolName)) continue;
                matching.add(this.getSymbol(g, element, component));
                continue;
            }
            String[] stringArray = splitId;
            int n = splitId.length;
            int n2 = 0;
            while (n2 < n) {
                String split = stringArray[n2];
                if (name.equals(split)) {
                    matching.add(this.getSymbol(g, element, component));
                }
                ++n2;
            }
        }
        return matching;
    }

    public T getSingleSymbol(ReadGraph g, String symbolName, Resource symbolType) throws DatabaseException {
        List<T> matching = this.getSymbol(g, symbolName, symbolType);
        if (matching.size() == 1) {
            return (T)((Symbol)matching.get(0));
        }
        if (matching.size() == 0) {
            return null;
        }
        throw new NoSingleResultException("There are multiple symbols with name '" + symbolName + "' and type " + symbolType);
    }

    public T getPossibleSymbol(ReadGraph g, String symbolName, Resource symbolType) throws DatabaseException {
        List<T> matching = this.getSymbol(g, symbolName, symbolType);
        if (matching.size() == 1) {
            return (T)((Symbol)matching.get(0));
        }
        return null;
    }

    public List<T> getSymbol(ReadGraph g, String symbolName, Resource symbolType) throws DatabaseException {
        List<T> nameMatching = this.getSymbol(g, symbolName);
        ArrayList<Symbol> matching = new ArrayList<Symbol>();
        for (Symbol s : nameMatching) {
            if (!g.isInstanceOf(s.getElement(), symbolType) && !g.isInstanceOf(s.getComponent(), symbolType)) continue;
            matching.add(s);
        }
        return matching;
    }

    public Symbol getFlag(ReadGraph g, Resource flagType, String symbolName, Resource symbolType) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        ArrayList<T> matching = new ArrayList<T>();
        for (Resource flag : OrderedSetUtils.toList((ReadGraph)g, (Resource)this.diagram)) {
            T flagSymbol;
            Symbol connectedSymbol;
            Resource component;
            if (!g.isInstanceOf(flag, dr.Flag) || !g.getSingleObject(flag, dr.HasFlagType).equals(flagType) || (component = (connectedSymbol = ((Symbol)(flagSymbol = this.getSymbol(g, flag, null))).getDiagramSingleConnected(g, dr.Flag_ConnectionPoint)).getComponent()) == null) continue;
            String label = (String)g.getPossibleRelatedValue(component, b.HasLabel);
            String name = (String)g.getRelatedValue(component, b.HasName);
            if (label != null) {
                String[] splitId = symbolName.split(";");
                if (splitId.length > 1) {
                    Object[] splitLabel = label.split(";");
                    boolean match = true;
                    int i = 0;
                    while (i < splitId.length) {
                        if (!Arrays.contains((Object[])splitLabel, (Object)splitId[i])) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (!match || !g.isInstanceOf(connectedSymbol.getElement(), symbolType) && !g.isInstanceOf(component, symbolType)) continue;
                    matching.add(this.getSymbol(g, flag, null));
                    continue;
                }
                if (!label.equals(symbolName) && !name.equals(symbolName) || !g.isInstanceOf(connectedSymbol.getElement(), symbolType) && !g.isInstanceOf(component, symbolType)) continue;
                matching.add(this.getSymbol(g, flag, null));
                continue;
            }
            if (!name.equals(symbolName) || !g.isInstanceOf(connectedSymbol.getElement(), symbolType) && !g.isInstanceOf(component, symbolType)) continue;
            matching.add(this.getSymbol(g, flag, null));
        }
        if (matching.size() == 1) {
            return (Symbol)matching.get(0);
        }
        if (matching.size() == 0) {
            return null;
        }
        throw new NoSingleResultException("There are multiple flags connecting symbol with name '" + symbolName + "' and type " + symbolType);
    }

    public PageDesc getPageDesc(ReadGraph g) throws DatabaseException {
        PageDesc pDesc = DiagramGraphUtil.getPageDesc((ReadGraph)g, (Resource)this.diagram, (PageDesc)PageDesc.DEFAULT);
        return pDesc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Diagram other = (Diagram)o;
        return this.diagram.equals(other.diagram);
    }

    public int hashCode() {
        return this.diagram.hashCode();
    }

    void merge(Symbol to, Symbol from) {
        Resource element = from.getElement();
        for (Symbol s : this.elementToSymbolMap.values()) {
            if (!s.element.equals(element)) continue;
            s.element = to.element;
            s.component = to.component;
        }
        from.element = to.element;
        from.component = to.component;
    }

    public Resource getModel(ReadGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)g);
        Resource r = this.composite;
        Resource parent;
        while (!g.isInstanceOf(parent = g.getSingleObject(r, l0.PartOf), sim.Model)) {
            r = parent;
        }
        return parent;
    }
}

