/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class ThrowStatement
extends Statement {
    public static final TokenRole THROW_KEYWORD_ROLE = new TokenRole("throw", 1);

    public ThrowStatement(Expression expression) {
        super(expression.getOffset());
        this.setExpression(expression);
    }

    public final JavaTokenNode getThrowToken() {
        return this.getChildByRole(THROW_KEYWORD_ROLE);
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitThrowStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ThrowStatement && !other.isNull() && this.getExpression().matches(((ThrowStatement)other).getExpression(), match);
    }
}

