/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.AutoConvertingDecoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.types.Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.function.Function;

abstract class AutoConvertingTextDecoder<N>
extends BaseTextDecoder
implements AutoConvertingDecoder {
    private AutoConvertingDecoder.Converter<N> converter;

    protected AutoConvertingTextDecoder(Function<N, String> converter) {
        this(new AutoConvertingDecoder.ToStringConverter<N>(converter));
    }

    protected AutoConvertingTextDecoder(AutoConvertingDecoder.Converter<N> converter) {
        this.converter = converter;
    }

    protected Object convertOutput(Context context, N decoded, Class<?> targetClass, Object targetContext) throws IOException {
        if (targetClass.isInstance(decoded)) {
            return targetClass.cast(decoded);
        }
        return this.converter.convert(context, decoded, targetClass, targetContext);
    }

    private boolean isBinary(Class<?> type) {
        return type == InputStream.class || type == byte[].class;
    }

    @Override
    protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
        if (this.isBinary(targetClass)) {
            int length = buffer.length();
            if (this.shouldRespectMaxLength()) {
                Integer maxLength = context.getSetting(SystemSettings.FIELD_LENGTH_MAX);
                length = maxLength != null ? maxLength : length;
            }
            byte[] bytes = buffer.subSequence(0, length).toString().getBytes(context.getCharset());
            Object binaryResult = null;
            if (targetClass == InputStream.class) {
                binaryResult = new ByteArrayInputStream(bytes);
            } else if (targetClass == byte[].class) {
                binaryResult = bytes;
            }
            return binaryResult;
        }
        N decoded = this.decodeNativeValue(context, type, typeLength, typeModifier, buffer, targetClass, targetContext);
        Object converted = this.convertOutput(context, decoded, targetClass, targetContext);
        if (converted == null) {
            throw new ConversionException("Unable to convert value to " + targetClass);
        }
        return converted;
    }

    @Override
    public abstract Class<N> getDefaultClass();

    protected abstract N decodeNativeValue(Context var1, Type var2, Short var3, Integer var4, CharSequence var5, Class<?> var6, Object var7) throws IOException, ParseException;
}

